/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.generic_jca_adapter;

import ch.maxant.generic_jca_adapter.TransactionAssistant;
import java.io.Serializable;
import java.util.Objects;
import javax.resource.Referenceable;
import javax.resource.ResourceException;

public interface TransactionAssistanceFactory
extends Serializable,
Referenceable {
    public TransactionAssistant getTransactionAssistant() throws ResourceException;

    public void registerCommitRollbackRecovery(CommitRollbackRecoveryCallback var1);

    public void unregisterCommitRollbackRecovery();

    public static interface CommitRollbackRecoveryCallback {
        public String[] getTransactionsInNeedOfRecovery();

        public void commit(String var1) throws Exception;

        public void rollback(String var1) throws Exception;

        public static class Builder {
            private CommitRollbackFunction commit;
            private CommitRollbackFunction rollback;
            private RecoveryFunction recovery;

            public Builder withCommit(CommitRollbackFunction commit) {
                this.commit = commit;
                return this;
            }

            public Builder withRollback(CommitRollbackFunction rollback) {
                this.rollback = rollback;
                return this;
            }

            public Builder withRecovery(RecoveryFunction recovery) {
                this.recovery = recovery;
                return this;
            }

            public CommitRollbackRecoveryCallback build() {
                Objects.requireNonNull(this.commit, "Please call withCommit(...)");
                Objects.requireNonNull(this.rollback, "Please call withRollback(...)");
                return new CommitRollbackRecoveryCallback(){

                    @Override
                    public void commit(String txid) throws Exception {
                        Builder.this.commit.apply(txid);
                    }

                    @Override
                    public void rollback(String txid) throws Exception {
                        Builder.this.rollback.apply(txid);
                    }

                    @Override
                    public String[] getTransactionsInNeedOfRecovery() {
                        if (Builder.this.recovery == null) {
                            return new String[0];
                        }
                        return Builder.this.recovery.getTransactionsInNeedOfRecovery();
                    }
                };
            }

            public static interface CommitRollbackFunction {
                public void apply(String var1) throws Exception;
            }

            public static interface RecoveryFunction {
                public String[] getTransactionsInNeedOfRecovery();
            }
        }
    }
}

