/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.generic_jca_adapter;

import ch.maxant.generic_jca_adapter.BasicTransactionAssistanceFactory;
import ch.maxant.generic_jca_adapter.CommitRollbackCallback;
import java.io.Serializable;
import java.util.Objects;
import javax.resource.Referenceable;

public interface TransactionAssistanceFactory
extends Serializable,
Referenceable,
BasicTransactionAssistanceFactory {
    public void registerCommitRollbackRecovery(CommitRollbackRecoveryCallback var1);

    public void unregisterCommitRollbackRecovery();

    public static interface CommitRollbackRecoveryCallback
    extends CommitRollbackCallback {
        public String[] getTransactionsInNeedOfRecovery();

        public static class Builder {
            private CommitRollbackFunction commit;
            private CommitRollbackFunction rollback;
            private RecoveryFunction recovery;

            public Builder withCommit(CommitRollbackFunction commit) {
                this.commit = commit;
                return this;
            }

            public Builder withRollback(CommitRollbackFunction rollback) {
                this.rollback = rollback;
                return this;
            }

            public Builder withRecovery(RecoveryFunction recovery) {
                this.recovery = recovery;
                return this;
            }

            public CommitRollbackRecoveryCallback build() {
                Objects.requireNonNull(this.commit, "Please call withCommit(...)");
                Objects.requireNonNull(this.rollback, "Please call withRollback(...)");
                return new CommitRollbackRecoveryCallback(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void commit(String txid) throws Exception {
                        Builder.this.commit.apply(txid);
                    }

                    @Override
                    public void rollback(String txid) throws Exception {
                        Builder.this.rollback.apply(txid);
                    }

                    @Override
                    public String[] getTransactionsInNeedOfRecovery() {
                        if (Builder.this.recovery == null) {
                            return new String[0];
                        }
                        return Builder.this.recovery.getTransactionsInNeedOfRecovery();
                    }
                };
            }

            public static interface CommitRollbackFunction {
                public void apply(String var1) throws Exception;
            }

            public static interface RecoveryFunction {
                public String[] getTransactionsInNeedOfRecovery();
            }
        }
    }
}

