/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.generic_jca_adapter;

import ch.maxant.generic_jca_adapter.AtomikosTransactionAssistantImpl;
import ch.maxant.generic_jca_adapter.BasicTransactionAssistanceFactory;
import ch.maxant.generic_jca_adapter.CommitRollbackCallback;
import ch.maxant.generic_jca_adapter.MicroserviceXAResource;
import ch.maxant.generic_jca_adapter.TransactionAssistant;
import ch.maxant.generic_jca_adapter.TransactionConfigurator;
import com.atomikos.icatch.jta.UserTransactionManager;
import javax.resource.ResourceException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class BasicTransactionAssistanceFactoryImpl
implements BasicTransactionAssistanceFactory {
    private String jndiName;

    public BasicTransactionAssistanceFactoryImpl(String jndiName) {
        this.jndiName = jndiName;
    }

    public TransactionAssistant getTransactionAssistant() throws ResourceException {
        CommitRollbackCallback commitRollbackCallback = TransactionConfigurator.getCommitRollbackCallback(this.jndiName);
        MicroserviceXAResource ms = new MicroserviceXAResource(this.jndiName, commitRollbackCallback);
        UserTransactionManager utm = this.getTM();
        try {
            if (utm.getStatus() == 6) {
                throw new ResourceException("no transaction found. please start one before getting the transaction assistant. status was: " + utm.getStatus());
            }
            Transaction tx = utm.getTransaction();
            tx.enlistResource((XAResource)ms);
            return new AtomikosTransactionAssistantImpl(ms);
        }
        catch (Exception e) {
            throw new ResourceException("Unable to get transaction status", (Throwable)e);
        }
    }

    protected UserTransactionManager getTM() {
        return new UserTransactionManager();
    }
}

