/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.generic_jca_adapter;

import ch.maxant.generic_jca_adapter.CommitRollbackCallback;
import ch.maxant.generic_jca_adapter.MicroserviceXAResource;
import ch.maxant.generic_jca_adapter.RecoverableMSResource;
import com.atomikos.datasource.RecoverableResource;
import com.atomikos.icatch.config.UserTransactionServiceImp;
import java.util.HashMap;
import java.util.Map;

public final class TransactionConfigurator {
    private static Map<String, RecoverableMSResource> resources = new HashMap<String, RecoverableMSResource>();

    private TransactionConfigurator() {
    }

    public static void setup(String jndiName, CommitRollbackCallback commitRollbackCallback) {
        UserTransactionServiceImp utsi = new UserTransactionServiceImp();
        MicroserviceXAResource ms = new MicroserviceXAResource(jndiName, commitRollbackCallback);
        RecoverableMSResource resource = new RecoverableMSResource(ms);
        resources.put(jndiName, resource);
        utsi.registerResource((RecoverableResource)resource);
    }

    public static void unregisterMicroserviceResourceFactory(String name) {
        UserTransactionServiceImp utsi = new UserTransactionServiceImp();
        utsi.removeResource((RecoverableResource)resources.remove(name));
    }

    static CommitRollbackCallback getCommitRollbackCallback(String jndiName) {
        RecoverableMSResource rr = resources.get(jndiName);
        if (rr != null) {
            return rr.getMicroserviceResource().getUnderlyingConnection();
        }
        return null;
    }
}

