/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.generic_jca_adapter;

import ch.maxant.generic_jca_adapter.ExecuteCallback;
import ch.maxant.generic_jca_adapter.MicroserviceXAResource;
import ch.maxant.generic_jca_adapter.TransactionAssistant;
import com.atomikos.icatch.jta.UserTransactionManager;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

class AtomikosTransactionAssistantImpl
implements TransactionAssistant {
    private MicroserviceXAResource ms;

    AtomikosTransactionAssistantImpl(MicroserviceXAResource ms) {
        this.ms = ms;
    }

    public <O> O executeInActiveTransaction(ExecuteCallback<O> c) throws Exception {
        return (O)this.ms.executeInActiveTransaction(c);
    }

    public void close() {
        UserTransactionManager utm = this.getTransactionManager();
        try {
            if (utm.getStatus() == 6) {
                throw new RuntimeException("no transaction found. please start one before getting the transaction assistant. status was: " + utm.getStatus());
            }
            Transaction tx = utm.getTransaction();
            tx.delistResource((XAResource)this.ms, this.ms.getUnderlyingConnection().wasExecuteSuccessful() ? 0x4000000 : 0x20000000);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to delist resource from transaction", e);
        }
    }

    protected UserTransactionManager getTransactionManager() {
        return new UserTransactionManager();
    }
}

