/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.generic_jca_adapter;

import bitronix.tm.internal.BitronixRuntimeException;
import bitronix.tm.internal.XAResourceHolderState;
import bitronix.tm.recovery.RecoveryException;
import bitronix.tm.resource.ResourceObjectFactory;
import bitronix.tm.resource.ResourceRegistrar;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.common.XAResourceHolder;
import bitronix.tm.resource.common.XAResourceProducer;
import ch.maxant.generic_jca_adapter.BasicTransactionAssistanceFactory;
import ch.maxant.generic_jca_adapter.ExecuteCallback;
import ch.maxant.generic_jca_adapter.MicroserviceResourceFactory;
import ch.maxant.generic_jca_adapter.MicroserviceResourceHolder;
import ch.maxant.generic_jca_adapter.MicroserviceXAResource;
import ch.maxant.generic_jca_adapter.TransactionAssistant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.resource.ResourceException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MicroserviceResourceProducer
extends ResourceBean
implements XAResourceProducer,
BasicTransactionAssistanceFactory {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((String)MicroserviceResourceProducer.class.getName());
    private static final ConcurrentMap<String, MicroserviceResourceProducer> producers = new ConcurrentHashMap<String, MicroserviceResourceProducer>();
    private volatile RecoveryXAResourceHolder recoveryXAResourceHolder;
    private MicroserviceResourceFactory msrFactory;
    private ConcurrentMap<XAResource, MicroserviceResourceHolder> resourceHolders = new ConcurrentHashMap<XAResource, MicroserviceResourceHolder>();

    private MicroserviceResourceProducer() {
        this.setApplyTransactionTimeout(true);
    }

    public static void registerMicroserviceResourceFactory(String uniqueName, MicroserviceResourceFactory msrFactory) {
        MicroserviceResourceProducer msResourceProducer = (MicroserviceResourceProducer)((Object)producers.get(uniqueName));
        if (msResourceProducer != null) {
            throw new IllegalStateException("already added a factory with the name " + uniqueName + "!");
        }
        msResourceProducer = new MicroserviceResourceProducer();
        msResourceProducer.setUniqueName(uniqueName);
        msResourceProducer.setFactory(msrFactory);
        producers.put(uniqueName, msResourceProducer);
        msResourceProducer.init();
    }

    private void setFactory(MicroserviceResourceFactory msrFactory) {
        this.msrFactory = msrFactory;
    }

    public static void unregisterMicroserviceResourceFactory(String uniqueName) {
        MicroserviceResourceProducer msResourceProducer = (MicroserviceResourceProducer)((Object)producers.remove(uniqueName));
        if (msResourceProducer != null) {
            msResourceProducer.setFactory(null);
            msResourceProducer.close();
        } else {
            log.error("no MicroserviceResource Factory registered with name " + uniqueName);
        }
    }

    public XAResourceHolderState startRecovery() throws RecoveryException {
        if (this.recoveryXAResourceHolder != null) {
            throw new RecoveryException("recovery already in progress on " + (Object)((Object)this));
        }
        if (this.msrFactory == null) {
            throw new RecoveryException("no MicroserviceResource Factory registered, recovery cannot be done on " + (Object)((Object)this));
        }
        this.recoveryXAResourceHolder = new RecoveryXAResourceHolder((XAResourceHolder)new MicroserviceResourceHolder((XAResource)this.msrFactory.build(), this));
        return new XAResourceHolderState((XAResourceHolder)this.recoveryXAResourceHolder, (ResourceBean)this);
    }

    public void endRecovery() throws RecoveryException {
        this.recoveryXAResourceHolder = null;
    }

    public void setFailed(boolean failed) {
    }

    public MicroserviceResourceHolder findXAResourceHolder(XAResource xaResource) {
        return (MicroserviceResourceHolder)((Object)this.resourceHolders.get(xaResource));
    }

    public void init() {
        try {
            ResourceRegistrar.register((XAResourceProducer)this);
        }
        catch (RecoveryException ex) {
            throw new BitronixRuntimeException("error recovering " + (Object)((Object)this), (Throwable)ex);
        }
    }

    public void close() {
        ResourceRegistrar.unregister((XAResourceProducer)this);
    }

    public MicroserviceResourceHolder createPooledConnection(Object xaFactory, ResourceBean bean) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Reference getReference() throws NamingException {
        return new Reference(MicroserviceResourceProducer.class.getName(), new StringRefAddr("uniqueName", this.getUniqueName()), ResourceObjectFactory.class.getName(), null);
    }

    public String toString() {
        return "a MicroserviceResourceProducer with uniqueName " + this.getUniqueName();
    }

    public TransactionAssistant getTransactionAssistant() throws ResourceException {
        final MicroserviceXAResource microserviceResource = this.msrFactory.build();
        final MicroserviceResourceHolder resourceHolder = new MicroserviceResourceHolder((XAResource)microserviceResource, this);
        this.resourceHolders.put(resourceHolder.getXAResource(), resourceHolder);
        try {
            TransactionContextHelper.enlistInCurrentTransaction((XAResourceHolder)resourceHolder);
        }
        catch (Exception e) {
            throw new ResourceException("Unable to enlist resource into transaction", (Throwable)e);
        }
        return new TransactionAssistant(){

            public <T> T executeInActiveTransaction(ExecuteCallback<T> c) throws Exception {
                return (T)microserviceResource.executeInActiveTransaction(c);
            }

            public void close() {
                try {
                    TransactionContextHelper.delistFromCurrentTransaction((XAResourceHolder)resourceHolder);
                }
                catch (SystemException e) {
                    throw new RuntimeException(e);
                }
                MicroserviceResourceProducer.this.resourceHolders.remove(resourceHolder.getXAResource());
            }
        };
    }

    static ConcurrentMap<String, MicroserviceResourceProducer> getProducers() {
        return producers;
    }
}

