/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.generic_jca_adapter;

import ch.maxant.generic_jca_adapter.TransactionAssistanceFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.Connector;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

@Connector(licenseRequired=true, transactionSupport=TransactionSupport.TransactionSupportLevel.XATransaction)
public class GenericResourceAdapter
implements ResourceAdapter {
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private Map<String, TransactionAssistanceFactory.CommitRollbackRecoveryCallback> commitRollbackRecoveryCallbacks = new HashMap<String, TransactionAssistanceFactory.CommitRollbackRecoveryCallback>();

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        this.log.log(Level.INFO, "activating endpoint");
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        this.log.log(Level.INFO, "deactivating endpoint");
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        this.log.log(Level.INFO, "starting resource adapter");
    }

    public void stop() {
        this.log.log(Level.INFO, "stopping resource adapter");
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        this.log.log(Level.INFO, "getting xa resources");
        throw new ResourceException("not supported - altho we can if its necessary...");
    }

    public int hashCode() {
        return 69;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    synchronized void registerCommitRollbackRecovery(String managedConnectionFactoryId, TransactionAssistanceFactory.CommitRollbackRecoveryCallback commitRollbackRecoveryCallback) {
        if (this.commitRollbackRecoveryCallbacks.containsKey(managedConnectionFactoryId)) {
            throw new IllegalStateException("Unable to register commit/rollback/recovery for managed connection factory with ID '" + managedConnectionFactoryId + "', because a callback has already been registered. Please unregister it first!");
        }
        this.commitRollbackRecoveryCallbacks.put(managedConnectionFactoryId, commitRollbackRecoveryCallback);
    }

    synchronized void unregisterCommitRollbackRecovery(String managedConnectionFactoryId) {
        this.commitRollbackRecoveryCallbacks.remove(managedConnectionFactoryId);
    }

    TransactionAssistanceFactory.CommitRollbackRecoveryCallback getCommitRollbackRecoveryCallback(String managedConnectionFactoryId) {
        return this.commitRollbackRecoveryCallbacks.get(managedConnectionFactoryId);
    }
}

