/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.generic_jca_adapter;

import ch.maxant.generic_jca_adapter.ExecuteCallback;
import ch.maxant.generic_jca_adapter.ManagedTransactionAssistanceMetaData;
import ch.maxant.generic_jca_adapter.TransactionAssistanceFactory;
import ch.maxant.generic_jca_adapter.TransactionAssistanceXAResource;
import ch.maxant.generic_jca_adapter.TransactionAssistant;
import ch.maxant.generic_jca_adapter.TransactionAssistantImpl;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class ManagedTransactionAssistance
implements ManagedConnection,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private PrintWriter logWriter;
    private List<ConnectionEventListener> listeners = new ArrayList<ConnectionEventListener>();
    private TransactionAssistant connection;
    private Boolean executeWasSuccessful;
    private String currentTxId;
    private TransactionAssistanceFactory.CommitRollbackRecoveryCallback commitRollbackRecoveryCallback;
    private TransactionAssistanceXAResource xa;
    private boolean handleRecoveryInternally;
    private File recoveryStatePersistenceDirectory;
    private String managedConnectionFactoryId;

    public ManagedTransactionAssistance(TransactionAssistanceFactory.CommitRollbackRecoveryCallback commitRollbackRecoveryCallback, boolean handleRecoveryInternally, File recoveryStatePersistenceDirectory, String managedConnectionFactoryId) {
        this.commitRollbackRecoveryCallback = commitRollbackRecoveryCallback;
        this.handleRecoveryInternally = handleRecoveryInternally;
        this.recoveryStatePersistenceDirectory = recoveryStatePersistenceDirectory;
        this.managedConnectionFactoryId = managedConnectionFactoryId;
        this.xa = new TransactionAssistanceXAResource(this);
        this.connection = new TransactionAssistantImpl(this);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.logWriter = logWriter;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        return this.connection;
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (!(connection instanceof TransactionAssistant)) {
            throw new IllegalArgumentException("Connection must be of type TransactionAssistant instead of " + connection.getClass());
        }
        this.connection = (TransactionAssistant)connection;
    }

    public void cleanup() throws ResourceException {
        this.log.log(Level.INFO, "cleaning up managed connection");
        this.currentTxId = null;
        this.executeWasSuccessful = null;
    }

    public void destroy() throws ResourceException {
        this.connection = null;
        this.xa = null;
        this.currentTxId = null;
        this.executeWasSuccessful = null;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        this.listeners.remove(listener);
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException("LocalTransaction not supported");
    }

    public XAResource getXAResource() throws ResourceException {
        return this.xa;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new ManagedTransactionAssistanceMetaData();
    }

    public <O> O execute(ExecuteCallback<O> f) throws Exception {
        if (this.currentTxId == null) {
            throw new IllegalStateException("XID not yet set - was transaction started?");
        }
        if (this.executeWasSuccessful != null) {
            throw new IllegalStateException("not closed?");
        }
        if (this.handleRecoveryInternally) {
            this.persistTransactionState();
        }
        try {
            Object o = f.execute(this.currentTxId);
            this.executeWasSuccessful = true;
            return (O)o;
        }
        catch (Exception e) {
            this.executeWasSuccessful = false;
            throw e;
        }
    }

    private void persistTransactionState() throws IOException {
        Files.write(File.createTempFile("exec.", ".txt", this.getRecoveryStatePersistenceDirectory()).toPath(), this.currentTxId.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public void close(TransactionAssistant handle) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)handle);
        for (ConnectionEventListener l : this.listeners) {
            l.connectionClosed(event);
        }
    }

    public boolean wasExecuteSuccessful() {
        if (this.executeWasSuccessful == null) {
            throw new IllegalStateException("not expecting a call to wasExecuteSuccessful at this time");
        }
        return this.executeWasSuccessful;
    }

    public void setCurrentTxId(String txId) {
        if (this.currentTxId != null) {
            throw new IllegalStateException("not ready for a new transaction - was this connection closed?");
        }
        this.currentTxId = txId;
    }

    public TransactionAssistanceFactory.CommitRollbackRecoveryCallback getCommitRollbackRecoveryCallback() {
        return this.commitRollbackRecoveryCallback;
    }

    public boolean isHandleRecoveryInternally() {
        return this.handleRecoveryInternally;
    }

    public File getRecoveryStatePersistenceDirectory() {
        return this.recoveryStatePersistenceDirectory;
    }

    public String getManagedConnectionFactoryId() {
        return this.managedConnectionFactoryId;
    }
}

