/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.generic_jca_adapter;

import ch.maxant.generic_jca_adapter.GenericResourceAdapter;
import ch.maxant.generic_jca_adapter.ManagedTransactionAssistance;
import ch.maxant.generic_jca_adapter.TransactionAssistanceFactory;
import ch.maxant.generic_jca_adapter.TransactionAssistanceFactoryImpl;
import ch.maxant.generic_jca_adapter.TransactionAssistant;
import ch.maxant.generic_jca_adapter.TransactionAssistantImpl;
import java.io.File;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConfigProperty;
import javax.resource.spi.ConnectionDefinition;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.security.auth.Subject;

@ConnectionDefinition(connectionFactory=TransactionAssistanceFactory.class, connectionFactoryImpl=TransactionAssistanceFactoryImpl.class, connection=TransactionAssistant.class, connectionImpl=TransactionAssistantImpl.class)
public class ManagedTransactionAssistanceFactory
implements ManagedConnectionFactory,
ResourceAdapterAssociation {
    private static final long serialVersionUID = 1L;
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private PrintWriter logWriter;
    private ResourceAdapter resourceAdapter;
    @ConfigProperty(supportsDynamicUpdates=false, defaultValue="false")
    private String handleRecoveryInternally;
    @ConfigProperty(supportsDynamicUpdates=false, defaultValue="")
    private String recoveryStatePersistenceDirectory;
    @ConfigProperty(supportsDynamicUpdates=false)
    private String id;
    private File recoveryStatePersistenceDirectoryFile;
    private boolean initialised = false;

    private synchronized void lazyInit() {
        if (this.initialised) {
            return;
        }
        if (this.isHandleRecoveryInternally().booleanValue()) {
            if (this.recoveryStatePersistenceDirectory == null || this.recoveryStatePersistenceDirectory.isEmpty()) {
                this.log.log(Level.SEVERE, "The '" + this.id + "' adapter has been configured to handle recovery state internally, but the configuration property 'recoveryStatePersistenceDirectoryConfig' has not been set!");
            } else {
                this.log.log(Level.WARNING, "The '" + this.id + "' adapter WILL track transaction state internally. The associated EIS does NOT need to be able to return incomplete transactions and there is NO need to provide an implementation of CommitRollbackRecoveryCallback#getTransactionsInNeedOfRecovery().");
                this.recoveryStatePersistenceDirectoryFile = new File(this.recoveryStatePersistenceDirectory);
                if (!this.recoveryStatePersistenceDirectoryFile.exists()) {
                    if (!this.recoveryStatePersistenceDirectoryFile.mkdirs()) {
                        String msg = "FAILED TO CREATE DIRECTORY '" + this.recoveryStatePersistenceDirectoryFile.getAbsolutePath() + "' - the resource adapter will be unable to track state. Throwing exception now...";
                        this.log.log(Level.SEVERE, msg);
                        throw new RuntimeException(msg);
                    }
                    this.log.log(Level.INFO, "Transaction state for '" + this.id + "' will be written in new directory '" + this.recoveryStatePersistenceDirectoryFile.getAbsolutePath() + "'");
                } else {
                    this.log.log(Level.INFO, "Transaction state for '" + this.id + "' will be written in existing directory '" + this.recoveryStatePersistenceDirectoryFile.getAbsolutePath() + "'");
                }
            }
        } else {
            this.log.log(Level.WARNING, "The '" + this.id + "' adapter will NOT track transaction state internally. The associated EIS MUST be able to return incomplete transactions and you MUST provide an implementation of CommitRollbackRecoveryCallback#getTransactionsInNeedOfRecovery()!");
        }
        this.initialised = true;
    }

    public Object createConnectionFactory() throws ResourceException {
        this.lazyInit();
        throw new ResourceException("This resource adapter doesn't support non-managed environments");
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        this.lazyInit();
        return new TransactionAssistanceFactoryImpl(this, cxManager);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.lazyInit();
        TransactionAssistanceFactory.CommitRollbackRecoveryCallback callback = ((GenericResourceAdapter)this.resourceAdapter).getCommitRollbackRecoveryCallback(this.id);
        return new ManagedTransactionAssistance(callback, this.isHandleRecoveryInternally(), this.recoveryStatePersistenceDirectoryFile, this.id);
    }

    private Boolean isHandleRecoveryInternally() {
        return Boolean.valueOf(this.handleRecoveryInternally);
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.lazyInit();
        ManagedConnection result = null;
        Iterator it = connectionSet.iterator();
        while (result == null && it.hasNext()) {
            ManagedConnection mc = (ManagedConnection)it.next();
            if (!(mc instanceof ManagedTransactionAssistance) || cxRequestInfo == null) continue;
            ManagedTransactionAssistance managedTransactionAssistance = (ManagedTransactionAssistance)mc;
        }
        return result;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.logWriter = logWriter;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) throws ResourceException {
        this.resourceAdapter = resourceAdapter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ManagedTransactionAssistanceFactory other = (ManagedTransactionAssistanceFactory)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public void setHandleRecoveryInternally(String handleRecoveryInternally) {
        this.handleRecoveryInternally = handleRecoveryInternally;
    }

    public void setRecoveryStatePersistenceDirectory(String recoveryStatePersistenceDirectory) {
        this.recoveryStatePersistenceDirectory = recoveryStatePersistenceDirectory;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }
}

