/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.generic_jca_adapter;

import ch.maxant.generic_jca_adapter.UnderlyingConnection;
import ch.maxant.generic_jca_adapter.XidImpl;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

abstract class AbstractTransactionAssistanceXAResource
implements XAResource,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static FileFilter executeFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().toLowerCase().startsWith("exec.");
        }
    };
    protected static final Logger log = Logger.getLogger(AbstractTransactionAssistanceXAResource.class.getName());
    protected int timeout = 300;

    AbstractTransactionAssistanceXAResource() {
    }

    protected abstract UnderlyingConnection getUnderlyingConnection();

    protected boolean isHandleRecoveryInternally() {
        return true;
    }

    protected abstract long getMinAgeOfTransactionBeforeRelevantForRecovery();

    protected abstract File getRecoveryStatePersistenceDirectory();

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        String s = XidImpl.asString(xid);
        log.log(Level.INFO, "COMMIT " + onePhase + "/" + s);
        try {
            this.getUnderlyingConnection().commit(s);
            if (this.isHandleRecoveryInternally()) {
                this.cleanupInternalTransactionState(xid);
            }
            this.getUnderlyingConnection().cleanup();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to COMMIT", e);
            int var = 4;
            throw new XAException(var);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        String s = "-";
        if (flags == 0x2000000) {
            s = "TMSUSPEND";
        } else if (flags == 0x20000000) {
            s = "TMFAIL";
        } else if (flags == 0x4000000) {
            s = "TMSUCCESS";
        }
        log.log(Level.INFO, "END flags=" + s + "(" + flags + ")" + "/" + XidImpl.asString(xid));
    }

    @Override
    public void forget(Xid xid) throws XAException {
        log.log(Level.INFO, "FORGET " + XidImpl.asString(xid));
        if (this.isHandleRecoveryInternally()) {
            this.cleanupInternalTransactionState(xid);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        log.log(Level.INFO, "PREPARE " + XidImpl.asString(xid));
        if (!this.getUnderlyingConnection().wasExecuteSuccessful()) {
            throw new XAException(100);
        }
        return 0;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        ArrayList<Xid> xids = new ArrayList<Xid>();
        switch (flag) {
            case 0x1000000: {
                String[] unfinishedTxIds;
                log.log(Level.INFO, "RECOVER TMSTARTRSCAN");
                UnderlyingConnection callback = this.getUnderlyingConnection();
                if (callback == null || (unfinishedTxIds = this.isHandleRecoveryInternally() ? this.getTransactionsInNeedOfRecovery() : callback.getTransactionsInNeedOfRecovery()) == null) break;
                for (String txId : unfinishedTxIds) {
                    log.log(Level.INFO, "recovery required for " + txId);
                    Xid xid = XidImpl.getXid(txId);
                    xids.add(xid);
                }
                break;
            }
            case 0x800000: {
                log.log(Level.INFO, "RECOVER TMENDRSCAN");
                break;
            }
            case 0: {
                log.log(Level.INFO, "RECOVER TMNOFLAGS");
                break;
            }
            default: {
                log.log(Level.INFO, "RECOVER " + flag);
            }
        }
        return xids.toArray(new Xid[0]);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        String s = XidImpl.asString(xid);
        log.log(Level.INFO, "ROLLBACK " + s);
        try {
            this.getUnderlyingConnection().rollback(s);
            if (this.isHandleRecoveryInternally()) {
                this.cleanupInternalTransactionState(xid);
            }
            this.getUnderlyingConnection().cleanup();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "failed to rollback for txid " + s, e);
            throw new XAException(4);
        }
    }

    private void cleanupInternalTransactionState(Xid xid) {
        boolean found = false;
        for (File f : this.getRecoveryStatePersistenceDirectory().listFiles(executeFilter)) {
            try {
                String content = this.read(f);
                if (!content.equals(XidImpl.asString(xid))) continue;
                found = true;
                if (!f.delete()) {
                    log.log(Level.WARNING, "Failed to delete file '" + f.getAbsolutePath() + "'. Please do this manually!");
                    break;
                }
                log.log(Level.FINE, "Transaction cleaned up: " + f.getName());
                break;
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
        if (!found) {
            log.log(Level.WARNING, "Unable to clean up internal state for transaction '" + xid + "' (" + XidImpl.asString(xid) + ") because no record of the transaction was found. Please report this as a bug.");
        }
    }

    private String read(File f) throws NoSuchFileException {
        try {
            return new String(Files.readAllBytes(f.toPath()), StandardCharsets.UTF_8);
        }
        catch (NoSuchFileException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeException("failed to read transaction state for file " + f.getAbsolutePath(), e);
        }
    }

    private String[] getTransactionsInNeedOfRecovery() {
        ArrayList<String> unfinishedTxs = new ArrayList<String>();
        for (File f : this.getRecoveryStatePersistenceDirectory().listFiles(executeFilter)) {
            try {
                if (this.getFileAgeInMs(f) <= this.getMinAgeOfTransactionBeforeRelevantForRecovery()) continue;
                String content = this.read(f);
                unfinishedTxs.add(content);
                log.log(Level.INFO, "Unfinished transaction found by generic resource adapter: " + f.getName());
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
        return unfinishedTxs.toArray(new String[0]);
    }

    private long getFileAgeInMs(File f) throws NoSuchFileException {
        try {
            BasicFileAttributes attr = Files.readAttributes(f.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return System.currentTimeMillis() - attr.creationTime().toMillis();
        }
        catch (NoSuchFileException e) {
            throw e;
        }
        catch (IOException e) {
            return Integer.MAX_VALUE;
        }
    }

    @Override
    public boolean setTransactionTimeout(int timeout) throws XAException {
        log.log(Level.INFO, "SET TRANSACTION TIMEOUT " + timeout);
        this.timeout = timeout;
        return true;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        String s = XidImpl.asString(xid);
        log.log(Level.INFO, "START " + flags + "/" + s);
        this.getUnderlyingConnection().setCurrentTxId(s);
    }
}

