/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.generic_jca_adapter;

import ch.maxant.generic_jca_adapter.AbstractTransactionAssistanceXAResource;
import ch.maxant.generic_jca_adapter.ManagedTransactionAssistance;
import ch.maxant.generic_jca_adapter.UnderlyingConnection;
import java.io.File;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class TransactionAssistanceXAResource
extends AbstractTransactionAssistanceXAResource {
    private static final long serialVersionUID = 1L;
    private ManagedTransactionAssistance conn;

    public TransactionAssistanceXAResource(ManagedTransactionAssistance conn) {
        this.conn = conn;
    }

    @Override
    protected long getMinAgeOfTransactionBeforeRelevantForRecovery() {
        return this.conn.getMinAgeOfTransactionBeforeRelevantForRecovery();
    }

    @Override
    protected File getRecoveryStatePersistenceDirectory() {
        return this.conn.getRecoveryStatePersistenceDirectory();
    }

    @Override
    protected boolean isHandleRecoveryInternally() {
        return this.conn.isHandleRecoveryInternally();
    }

    @Override
    protected UnderlyingConnection getUnderlyingConnection() {
        return new UnderlyingConnection(){
            private static final long serialVersionUID = 1L;

            public void rollback(String txid) throws Exception {
                TransactionAssistanceXAResource.this.conn.getCommitRollbackRecoveryCallback().rollback(txid);
            }

            public void commit(String txid) throws Exception {
                TransactionAssistanceXAResource.this.conn.getCommitRollbackRecoveryCallback().commit(txid);
            }

            @Override
            public boolean wasExecuteSuccessful() {
                return TransactionAssistanceXAResource.this.conn.wasExecuteSuccessful();
            }

            @Override
            public void setCurrentTxId(String txId) {
                TransactionAssistanceXAResource.this.conn.setCurrentTxId(txId);
            }

            @Override
            public String[] getTransactionsInNeedOfRecovery() {
                return TransactionAssistanceXAResource.this.conn.getCommitRollbackRecoveryCallback().getTransactionsInNeedOfRecovery();
            }

            @Override
            public void cleanup() throws ResourceException {
                TransactionAssistanceXAResource.this.conn.cleanup();
            }
        };
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        log.log(Level.FINEST, "isSameRM " + xares);
        if (xares instanceof TransactionAssistanceXAResource) {
            TransactionAssistanceXAResource other = (TransactionAssistanceXAResource)xares;
            if (this.conn.getManagedConnectionFactoryId().equals(other.conn.getManagedConnectionFactoryId())) {
                return true;
            }
        }
        return false;
    }
}

