/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.generic_jca_adapter;

import ch.maxant.generic_jca_adapter.AbstractTransactionAssistanceXAResource;
import ch.maxant.generic_jca_adapter.CommitRollbackCallback;
import ch.maxant.generic_jca_adapter.ExecuteCallback;
import ch.maxant.generic_jca_adapter.UnderlyingConnection;
import ch.maxant.generic_jca_adapter.UnderlyingConnectionImpl;
import java.io.File;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public class MicroserviceXAResource
extends AbstractTransactionAssistanceXAResource {
    private static final long serialVersionUID = 1L;
    private final UnderlyingConnectionImpl underlyingConnection;
    private static long minAgeOfTransactionInMSBeforeRelevantForRecovery = 30000L;
    private static File recoveryStatePersistenceDirectory = new File(".");
    private String jndiName;

    MicroserviceXAResource(String jndiName, final CommitRollbackCallback commitRollbackCallback) {
        this.jndiName = jndiName;
        this.underlyingConnection = new UnderlyingConnectionImpl(){
            private static final long serialVersionUID = 1L;

            public void rollback(String txid) throws Exception {
                commitRollbackCallback.rollback(txid);
            }

            public void commit(String txid) throws Exception {
                commitRollbackCallback.commit(txid);
            }
        };
    }

    protected long getMinAgeOfTransactionBeforeRelevantForRecovery() {
        return minAgeOfTransactionInMSBeforeRelevantForRecovery;
    }

    protected File getRecoveryStatePersistenceDirectory() {
        return recoveryStatePersistenceDirectory;
    }

    protected UnderlyingConnection getUnderlyingConnection() {
        return this.underlyingConnection;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        log.log(Level.FINEST, "isSameRM " + xares);
        if (xares instanceof MicroserviceXAResource) {
            MicroserviceXAResource other = (MicroserviceXAResource)((Object)xares);
            if (this.jndiName.equals(other.jndiName)) {
                return true;
            }
        }
        return false;
    }

    <O> O executeInActiveTransaction(ExecuteCallback<O> c) throws Exception {
        return this.underlyingConnection.execute(c, recoveryStatePersistenceDirectory);
    }

    public static void configure(long minAgeOfTransactionInMSBeforeRelevantForRecovery, File recoveryStatePersistenceDirectory) {
        MicroserviceXAResource.minAgeOfTransactionInMSBeforeRelevantForRecovery = minAgeOfTransactionInMSBeforeRelevantForRecovery;
        MicroserviceXAResource.recoveryStatePersistenceDirectory = recoveryStatePersistenceDirectory;
    }

    String getJndiName() {
        return this.jndiName;
    }
}

