/*
 * Decompiled with CFR 0.152.
 */
package ch.maxant.generic_jca_adapter;

import ch.maxant.generic_jca_adapter.ExecuteCallback;
import ch.maxant.generic_jca_adapter.UnderlyingConnection;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

abstract class UnderlyingConnectionImpl
implements UnderlyingConnection,
Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean wasExecuteSuccessful = null;
    private String currentTxId = null;

    UnderlyingConnectionImpl() {
    }

    protected <O> O execute(ExecuteCallback<O> c, File recoveryStatePersistenceDirectory) throws Exception {
        if (this.currentTxId == null) {
            throw new IllegalStateException("XID not yet set - was transaction started?");
        }
        if (this.wasExecuteSuccessful != null) {
            throw new IllegalStateException("not closed?");
        }
        this.persistTransactionState(recoveryStatePersistenceDirectory);
        try {
            Object o = c.execute(this.currentTxId);
            this.wasExecuteSuccessful = true;
            return (O)o;
        }
        catch (Exception e) {
            this.wasExecuteSuccessful = false;
            throw e;
        }
    }

    private void persistTransactionState(File recoveryStatePersistenceDirectory) throws IOException {
        Files.write(File.createTempFile("exec.", ".txt", recoveryStatePersistenceDirectory).toPath(), this.currentTxId.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public boolean wasExecuteSuccessful() {
        return this.wasExecuteSuccessful;
    }

    public void cleanup() {
        this.currentTxId = null;
        this.wasExecuteSuccessful = null;
    }

    public void setCurrentTxId(String txid) {
        this.currentTxId = txid;
    }

    public String[] getTransactionsInNeedOfRecovery() {
        throw new UnsupportedOperationException("should never be called, because the MicroserviceXAResource handles this internally");
    }
}

