/*
 * Decompiled with CFR 0.152.
 */
package ch.mfrey.maven.plugin.filerename;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="rename", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class RenamerMojo
extends AbstractMojo {
    @Parameter(required=true)
    private Replace[] replaces;
    @Parameter(defaultValue="false")
    private boolean showfiles;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private String basedir;
    @Parameter(readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File workingDir = new File(this.getBasedir());
        if (!workingDir.isAbsolute()) {
            workingDir = new File(this.project.getBasedir(), this.getBasedir());
        }
        this.getLog().info((CharSequence)("Directory: " + workingDir.getAbsolutePath()));
        for (Replace rep : this.getReplaces()) {
            this.getLog().info((CharSequence)rep.toString());
        }
        Collection files = FileUtils.listFiles((File)workingDir, (IOFileFilter)FileFileFilter.FILE, (IOFileFilter)DirectoryFileFilter.DIRECTORY);
        try {
            for (File file : files) {
                String newPath = this.getNewPath(workingDir, file);
                if (file.getAbsolutePath().equals(newPath)) continue;
                File newFile = new File(newPath);
                if (this.showfiles) {
                    this.getLog().info((CharSequence)(System.lineSeparator() + " - " + file.getAbsolutePath() + System.lineSeparator() + " + " + newFile.getAbsolutePath()));
                }
                FileUtils.moveFile((File)file, (File)newFile);
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Could not rename file", (Exception)ex);
        }
        try {
            this.cleanupEmptyDirs(workingDir);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Could not cleanup empty directories", (Exception)ex);
        }
    }

    private String getNewPath(File workingDir, File file) throws MojoExecutionException {
        String path = file.getAbsolutePath().substring(workingDir.getAbsolutePath().length());
        Replace[] replaces = this.getReplaces();
        for (int i = 0; i < replaces.length; ++i) {
            if (replaces[i].getFrom() == null || replaces[i].getTo() == null) {
                throw new MojoExecutionException("From and To cannot be NULL: " + replaces[i]);
            }
            if (replaces[i].getFrom().equals(replaces[i].getTo())) continue;
            path = path.replace(replaces[i].getFrom(), replaces[i].getTo());
        }
        return workingDir.getAbsolutePath() + path;
    }

    private void cleanupEmptyDirs(File directory) throws IOException {
        if (directory.isDirectory()) {
            for (File file : directory.listFiles()) {
                if (!file.isDirectory()) continue;
                this.cleanupEmptyDirs(file);
            }
            if (directory.list().length == 0) {
                FileUtils.deleteDirectory((File)directory);
            }
        }
    }

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public Replace[] getReplaces() {
        return this.replaces;
    }

    public void setReplaces(Replace[] replaces) {
        this.replaces = replaces;
    }

    public static class Replace {
        @Parameter(required=true)
        private String from;
        @Parameter(required=true)
        private String to;

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public String getTo() {
            return this.to;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Replace [from=").append(this.from).append(", to=").append(this.to).append("]");
            return builder.toString();
        }
    }
}

