/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import ch.mimo.netty.handler.codec.icap.DecodingException;
import ch.mimo.netty.handler.codec.icap.DefaultIcapChunk;
import ch.mimo.netty.handler.codec.icap.DefaultIcapChunkTrailer;
import ch.mimo.netty.handler.codec.icap.IcapMessageDecoder;
import ch.mimo.netty.handler.codec.icap.State;
import ch.mimo.netty.handler.codec.icap.StateEnum;
import ch.mimo.netty.handler.codec.icap.StateReturnValue;
import org.jboss.netty.buffer.ChannelBuffer;

public class ReadChunkedContentAsChunksState
extends State<Object> {
    public ReadChunkedContentAsChunksState(String name) {
        super(name);
    }

    @Override
    public void onEntry(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder) throws DecodingException {
    }

    @Override
    public StateReturnValue execute(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder) throws DecodingException {
        DefaultIcapChunk chunk = null;
        if (icapMessageDecoder.currentChunkSize > icapMessageDecoder.maxChunkSize) {
            chunk = new DefaultIcapChunk(buffer.readBytes(icapMessageDecoder.maxChunkSize));
            icapMessageDecoder.currentChunkSize -= icapMessageDecoder.maxChunkSize;
        } else {
            chunk = new DefaultIcapChunk(buffer.readBytes(icapMessageDecoder.currentChunkSize));
            icapMessageDecoder.currentChunkSize = 0;
        }
        chunk.setPreviewChunk(icapMessageDecoder.message.isPreviewMessage());
        if (chunk.isLast()) {
            icapMessageDecoder.currentChunkSize = 0;
            return StateReturnValue.createRelevantResult(new Object[]{chunk, new DefaultIcapChunkTrailer()});
        }
        return StateReturnValue.createRelevantResult(chunk);
    }

    @Override
    public StateEnum onExit(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder, Object decisionInformation) throws DecodingException {
        if (icapMessageDecoder.currentChunkSize == 0) {
            return StateEnum.READ_CHUNK_DELIMITER_STATE;
        }
        return StateEnum.READ_CHUNKED_CONTENT_AS_CHUNKS_STATE;
    }
}

