/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import ch.mimo.netty.handler.codec.icap.DefaultIcapChunk;
import ch.mimo.netty.handler.codec.icap.DefaultIcapChunkTrailer;
import ch.mimo.netty.handler.codec.icap.IcapMessage;
import ch.mimo.netty.handler.codec.icap.IcapMessageElementEnum;
import ch.mimo.netty.handler.codec.icap.IcapResponse;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.DownstreamMessageEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

public class IcapChunkSeparator
implements ChannelDownstreamHandler {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(IcapChunkSeparator.class);
    private int chunkSize;

    public IcapChunkSeparator(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof MessageEvent) {
            MessageEvent msgEvent = (MessageEvent)e;
            Object msg = msgEvent.getMessage();
            if (msg instanceof IcapMessage) {
                LOG.debug("Separation of message [" + msg.getClass().getName() + "] ");
                IcapMessage message = (IcapMessage)msg;
                ChannelBuffer content = this.extractContentFromMessage(message);
                this.fireDownstreamEvent(ctx, message, msgEvent);
                if (content != null) {
                    boolean isPreview = message.isPreviewMessage();
                    boolean isEarlyTerminated = false;
                    if (isPreview) {
                        boolean bl = isEarlyTerminated = content.readableBytes() < message.getPreviewAmount();
                    }
                    while (content.readableBytes() > 0) {
                        DefaultIcapChunk chunk = null;
                        chunk = content.readableBytes() > this.chunkSize ? new DefaultIcapChunk(content.readBytes(this.chunkSize)) : new DefaultIcapChunk(content.readBytes(content.readableBytes()));
                        chunk.setPreviewChunk(isPreview);
                        chunk.setEarlyTermination(isEarlyTerminated);
                        this.fireDownstreamEvent(ctx, chunk, msgEvent);
                        if (!(chunk.isLast() | content.readableBytes() <= 0)) continue;
                        DefaultIcapChunkTrailer trailer = new DefaultIcapChunkTrailer();
                        trailer.setPreviewChunk(isPreview);
                        trailer.setEarlyTermination(isEarlyTerminated);
                        this.fireDownstreamEvent(ctx, trailer, msgEvent);
                    }
                }
            } else {
                ctx.sendDownstream(e);
            }
        } else {
            ctx.sendDownstream(e);
        }
    }

    private ChannelBuffer extractContentFromMessage(IcapMessage message) {
        ChannelBuffer content = null;
        if (message instanceof IcapResponse && ((IcapResponse)message).getContent() != null) {
            IcapResponse response = (IcapResponse)message;
            content = response.getContent();
            if (content != null) {
                message.setBody(IcapMessageElementEnum.OPTBODY);
            }
        } else if (message.getHttpRequest() != null && message.getHttpRequest().getContent() != null && message.getHttpRequest().getContent().readableBytes() > 0) {
            content = message.getHttpRequest().getContent();
            message.setBody(IcapMessageElementEnum.REQBODY);
        } else if (message.getHttpResponse() != null && message.getHttpResponse().getContent() != null && message.getHttpResponse().getContent().readableBytes() > 0) {
            content = message.getHttpResponse().getContent();
            message.setBody(IcapMessageElementEnum.RESBODY);
        }
        return content;
    }

    private void fireDownstreamEvent(ChannelHandlerContext ctx, Object message, MessageEvent messageEvent) {
        DownstreamMessageEvent downstreamMessageEvent = new DownstreamMessageEvent(ctx.getChannel(), messageEvent.getFuture(), message, messageEvent.getRemoteAddress());
        ctx.sendDownstream((ChannelEvent)downstreamMessageEvent);
    }
}

