/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import java.nio.charset.Charset;

public final class IcapCodecUtil {
    public static final Byte[] IEOF_SEQUENCE = new Byte[]{(byte)48, (byte)59, (byte)32, (byte)105, (byte)101, (byte)111, (byte)102};
    public static final byte[] NATIVE_IEOF_SEQUENCE = new byte[]{48, 59, 32, 105, 101, 111, 102};
    public static final String IEOF_SEQUENCE_STRING = "0; ieof";
    public static final byte SPACE = 32;
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte[] CRLF = new byte[]{13, 10};
    public static final byte COLON = 58;
    public static final Charset ASCII_CHARSET = Charset.forName("ASCII");
    public static final String ENCAPSULATION_ELEMENT_REQHDR = "req-hdr";
    public static final String ENCAPSULATION_ELEMENT_RESHDR = "res-hdr";
    public static final String ENCAPSULATION_ELEMENT_REQBODY = "req-body";
    public static final String ENCAPSULATION_ELEMENT_RESBODY = "res-body";
    public static final String ENCAPSULATION_ELEMENT_OPTBODY = "opt-body";
    public static final String ENCAPSULATION_ELEMENT_NULLBODY = "null-body";

    private IcapCodecUtil() {
    }

    public static void validateHeaderName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        for (int i = 0; i < name.length(); ++i) {
            char caracter = name.charAt(i);
            if (caracter > '\u007f') {
                throw new IllegalArgumentException("name contains non-ascii character: " + name);
            }
            switch (caracter) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ',': 
                case ':': 
                case ';': 
                case '=': {
                    throw new IllegalArgumentException("name contains one of the following prohibited characters: =,;: \\t\\r\\n\\v\\f: " + name);
                }
            }
        }
    }

    public static void validateHeaderValue(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        int state = 0;
        for (int i = 0; i < value.length(); ++i) {
            char caracter = value.charAt(i);
            if (caracter == '\u000b' | caracter == '\f') {
                throw new IllegalArgumentException("value contains a prohibited character " + caracter + ": " + value);
            }
            if (state == 0) {
                if (caracter == '\r') {
                    state = 1;
                }
                if (caracter != '\n') continue;
                state = 2;
                continue;
            }
            if (state == 1) {
                if (caracter == '\n') {
                    state = 2;
                    continue;
                }
                throw new IllegalArgumentException("Only '\\n' is allowed after '\\r': " + value);
            }
            if (state != 2) continue;
            if (caracter == '\t') {
                state = 0;
                continue;
            }
            throw new IllegalArgumentException("Only ' ' and '\\t' are allowed after '\\n': " + value);
        }
        if (state != 0) {
            throw new IllegalArgumentException("value must not end with '\\r' or '\\n':" + value);
        }
    }
}

