/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import ch.mimo.netty.handler.codec.icap.DecodingException;
import ch.mimo.netty.handler.codec.icap.SizeDelimiter;
import java.util.ArrayList;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;

public final class IcapDecoderUtil {
    private IcapDecoderUtil() {
    }

    public static void skipControlCharacters(ChannelBuffer buffer) {
        char c;
        while (Character.isISOControl(c = (char)buffer.readUnsignedByte()) || Character.isWhitespace(c)) {
        }
        buffer.readerIndex(buffer.readerIndex() - 1);
    }

    public static String readLine(ChannelBuffer buffer, int maxLineLength) throws DecodingException {
        StringBuilder sb = new StringBuilder(64);
        int lineLength = 0;
        while (true) {
            byte nextByte;
            if ((nextByte = buffer.readByte()) == 13) {
                nextByte = buffer.readByte();
                if (nextByte != 10) continue;
                return sb.toString();
            }
            if (nextByte == 10) {
                return sb.toString();
            }
            if (lineLength >= maxLineLength) {
                throw new DecodingException((Throwable)new TooLongFrameException("An HTTP line is larger than " + maxLineLength + " bytes."));
            }
            ++lineLength;
            sb.append((char)nextByte);
        }
    }

    public static String previewLine(ChannelBuffer buffer, int maxLineLength) throws DecodingException {
        StringBuilder sb = new StringBuilder(64);
        int lineLength = 0;
        for (int i = buffer.readerIndex(); i < buffer.readableBytes(); ++i) {
            byte nextByte = buffer.getByte(i);
            if (nextByte == 13) {
                if ((nextByte = buffer.getByte(++i)) != 10) continue;
                break;
            }
            if (nextByte == 10) break;
            if (lineLength >= maxLineLength) {
                throw new DecodingException((Throwable)new TooLongFrameException("An HTTP line is larger than " + maxLineLength + " bytes."));
            }
            ++lineLength;
            sb.append((char)nextByte);
        }
        return sb.toString();
    }

    public static String[] splitInitialLine(String sb) {
        int aStart = IcapDecoderUtil.findNonWhitespace(sb, 0);
        int aEnd = IcapDecoderUtil.findWhitespace(sb, aStart);
        int bStart = IcapDecoderUtil.findNonWhitespace(sb, aEnd);
        int bEnd = IcapDecoderUtil.findWhitespace(sb, bStart);
        int cStart = IcapDecoderUtil.findNonWhitespace(sb, bEnd);
        int cEnd = IcapDecoderUtil.findEndOfString(sb);
        return new String[]{sb.substring(aStart, aEnd), sb.substring(bStart, bEnd), cStart < cEnd ? sb.substring(cStart, cEnd) : ""};
    }

    public static int findNonWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    public static int findWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && !Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    public static int findEndOfString(String sb) {
        int result;
        for (result = sb.length(); result > 0 && Character.isWhitespace(sb.charAt(result - 1)); --result) {
        }
        return result;
    }

    public static int getChunkSize(String line) throws DecodingException {
        String hex = line.trim();
        if (hex.equals("0; ieof")) {
            return -1;
        }
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (c != ';' && !Character.isWhitespace(c) && !Character.isISOControl(c)) continue;
            hex = hex.substring(0, i);
            break;
        }
        try {
            return Integer.parseInt(hex, 16);
        }
        catch (NumberFormatException nfe) {
            throw new DecodingException(nfe);
        }
    }

    public static List<String[]> readHeaders(ChannelBuffer buffer, int maxSize) throws DecodingException {
        ArrayList<String[]> headerList = new ArrayList<String[]>();
        SizeDelimiter sizeDelimiter = new SizeDelimiter(maxSize);
        String line = IcapDecoderUtil.readSingleHeaderLine(buffer, sizeDelimiter);
        String name = null;
        String value = null;
        if (line.length() != 0) {
            while (line.length() != 0) {
                if (name != null && IcapDecoderUtil.isHeaderLineSimpleValue(line)) {
                    value = value + ' ' + line.trim();
                } else {
                    if (name != null) {
                        headerList.add(new String[]{name, value});
                    }
                    String[] header = IcapDecoderUtil.splitHeader(line);
                    name = header[0];
                    value = header[1];
                }
                line = IcapDecoderUtil.readSingleHeaderLine(buffer, sizeDelimiter);
            }
            if (name != null) {
                headerList.add(new String[]{name, value});
            }
        }
        return headerList;
    }

    public static boolean isHeaderLineSimpleValue(String header) {
        char firstChar = header.charAt(0);
        return firstChar == ' ' || firstChar == '\t';
    }

    public static String readSingleHeaderLine(ChannelBuffer buffer, SizeDelimiter sizeDelimiter) throws DecodingException {
        StringBuilder sb = new StringBuilder(64);
        while (true) {
            char nextByte = (char)buffer.readByte();
            sizeDelimiter.increment();
            if (nextByte == '\r') {
                nextByte = (char)buffer.readByte();
                sizeDelimiter.increment();
                if (nextByte == '\n') {
                    break;
                }
            } else if (nextByte == '\n') break;
            sb.append(nextByte);
        }
        return sb.toString();
    }

    public static String[] splitHeader(String sb) {
        int valueStart;
        int colonEnd;
        int nameStart;
        char ch;
        int nameEnd;
        int length = sb.length();
        for (nameEnd = nameStart = IcapDecoderUtil.findNonWhitespace(sb, 0); nameEnd < length && (ch = sb.charAt(nameEnd)) != ':' && !Character.isWhitespace(ch); ++nameEnd) {
        }
        for (colonEnd = nameEnd; colonEnd < length; ++colonEnd) {
            if (sb.charAt(colonEnd) != ':') continue;
            ++colonEnd;
            break;
        }
        if ((valueStart = IcapDecoderUtil.findNonWhitespace(sb, colonEnd)) == length) {
            return new String[]{sb.substring(nameStart, nameEnd), ""};
        }
        int valueEnd = IcapDecoderUtil.findEndOfString(sb);
        return new String[]{sb.substring(nameStart, nameEnd), sb.substring(valueStart, valueEnd)};
    }
}

