/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import ch.mimo.netty.handler.codec.icap.Encapsulated;
import ch.mimo.netty.handler.codec.icap.IcapChunk;
import ch.mimo.netty.handler.codec.icap.IcapChunkTrailer;
import ch.mimo.netty.handler.codec.icap.IcapCodecUtil;
import ch.mimo.netty.handler.codec.icap.IcapMessage;
import ch.mimo.netty.handler.codec.icap.IcapMessageElementEnum;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.oneone.OneToOneEncoder;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

public abstract class IcapMessageEncoder
extends OneToOneEncoder {
    private final InternalLogger LOG = InternalLoggerFactory.getInstance(((Object)((Object)this)).getClass());

    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        this.LOG.debug("Encoding [" + msg.getClass().getName() + "]");
        if (msg instanceof IcapMessage) {
            IcapMessage message = (IcapMessage)msg;
            ChannelBuffer buffer = ChannelBuffers.dynamicBuffer((ChannelBufferFactory)channel.getConfig().getBufferFactory());
            this.encodeInitialLine(buffer, message);
            this.encodeHeaders(buffer, message);
            ChannelBuffer httpRequestBuffer = this.encodeHttpRequestHeader(message.getHttpRequest());
            ChannelBuffer httpResponseBuffer = this.encodeHttpResponseHeader(message.getHttpResponse());
            int index = 0;
            Encapsulated encapsulated = new Encapsulated();
            if (httpRequestBuffer.readableBytes() > 0) {
                encapsulated.addEntry(IcapMessageElementEnum.REQHDR, index);
                httpRequestBuffer.writeBytes(IcapCodecUtil.CRLF);
                index += httpRequestBuffer.readableBytes();
            }
            if (httpResponseBuffer.readableBytes() > 0) {
                encapsulated.addEntry(IcapMessageElementEnum.RESHDR, index);
                httpResponseBuffer.writeBytes(IcapCodecUtil.CRLF);
                index += httpResponseBuffer.readableBytes();
            }
            if (message.getBody() != null) {
                encapsulated.addEntry(message.getBody(), index);
            } else {
                encapsulated.addEntry(IcapMessageElementEnum.NULLBODY, index);
            }
            encapsulated.encode(buffer);
            buffer.writeBytes(httpRequestBuffer);
            buffer.writeBytes(httpResponseBuffer);
            return buffer;
        }
        if (msg instanceof IcapChunk) {
            ChannelBuffer buffer = ChannelBuffers.dynamicBuffer((ChannelBufferFactory)channel.getConfig().getBufferFactory());
            IcapChunk chunk = (IcapChunk)msg;
            if (chunk.isLast()) {
                if (chunk.isEarlyTerminated()) {
                    buffer.writeBytes(IcapCodecUtil.NATIVE_IEOF_SEQUENCE);
                    buffer.writeBytes(IcapCodecUtil.CRLF);
                    buffer.writeBytes(IcapCodecUtil.CRLF);
                } else if (msg instanceof IcapChunkTrailer) {
                    buffer.writeByte(48);
                    buffer.writeBytes(IcapCodecUtil.CRLF);
                    this.encodeTrailingHeaders(buffer, (IcapChunkTrailer)msg);
                    buffer.writeBytes(IcapCodecUtil.CRLF);
                } else {
                    buffer.writeByte(48);
                    buffer.writeBytes(IcapCodecUtil.CRLF);
                    buffer.writeBytes(IcapCodecUtil.CRLF);
                }
            } else {
                ChannelBuffer chunkBuffer = chunk.getContent();
                int contentLength = chunkBuffer.readableBytes();
                buffer.writeBytes(Integer.toHexString(contentLength).getBytes(IcapCodecUtil.ASCII_CHARSET));
                buffer.writeBytes(IcapCodecUtil.CRLF);
                buffer.writeBytes(chunkBuffer);
                buffer.writeBytes(IcapCodecUtil.CRLF);
            }
            return buffer;
        }
        return null;
    }

    protected abstract int encodeInitialLine(ChannelBuffer var1, IcapMessage var2) throws Exception;

    private ChannelBuffer encodeHttpRequestHeader(HttpRequest httpRequest) throws UnsupportedEncodingException {
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        if (httpRequest != null) {
            buffer.writeBytes(httpRequest.getMethod().toString().getBytes(IcapCodecUtil.ASCII_CHARSET));
            buffer.writeByte(32);
            buffer.writeBytes(httpRequest.getUri().getBytes(IcapCodecUtil.ASCII_CHARSET));
            buffer.writeByte(32);
            buffer.writeBytes(httpRequest.getProtocolVersion().toString().getBytes(IcapCodecUtil.ASCII_CHARSET));
            buffer.writeBytes(IcapCodecUtil.CRLF);
            for (Map.Entry h : httpRequest.getHeaders()) {
                this.encodeHeader(buffer, (String)h.getKey(), (String)h.getValue());
            }
        }
        return buffer;
    }

    private ChannelBuffer encodeHttpResponseHeader(HttpResponse httpResponse) throws UnsupportedEncodingException {
        ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
        if (httpResponse != null) {
            buffer.writeBytes(httpResponse.getProtocolVersion().toString().getBytes(IcapCodecUtil.ASCII_CHARSET));
            buffer.writeByte(32);
            buffer.writeBytes(httpResponse.getStatus().toString().getBytes(IcapCodecUtil.ASCII_CHARSET));
            buffer.writeBytes(IcapCodecUtil.CRLF);
            for (Map.Entry h : httpResponse.getHeaders()) {
                this.encodeHeader(buffer, (String)h.getKey(), (String)h.getValue());
            }
        }
        return buffer;
    }

    private int encodeTrailingHeaders(ChannelBuffer buffer, IcapChunkTrailer chunkTrailer) {
        int index = buffer.readableBytes();
        for (Map.Entry<String, String> h : chunkTrailer.getHeaders()) {
            this.encodeHeader(buffer, h.getKey(), h.getValue());
        }
        return buffer.readableBytes() - index;
    }

    private int encodeHeaders(ChannelBuffer buffer, IcapMessage message) {
        int index = buffer.readableBytes();
        for (Map.Entry<String, String> h : message.getHeaders()) {
            this.encodeHeader(buffer, h.getKey(), h.getValue());
        }
        return buffer.readableBytes() - index;
    }

    private void encodeHeader(ChannelBuffer buf, String header, String value) {
        buf.writeBytes(header.getBytes(IcapCodecUtil.ASCII_CHARSET));
        buf.writeByte(58);
        buf.writeByte(32);
        buf.writeBytes(value.getBytes(IcapCodecUtil.ASCII_CHARSET));
        buf.writeBytes(IcapCodecUtil.CRLF);
    }
}

