/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import java.util.HashMap;
import java.util.Map;

public final class IcapMethod {
    public static final IcapMethod REQMOD = new IcapMethod("REQMOD");
    public static final IcapMethod RESPMOD = new IcapMethod("RESPMOD");
    public static final IcapMethod OPTIONS = new IcapMethod("OPTIONS");
    private static final Map<String, IcapMethod> METHOD_MAP = new HashMap<String, IcapMethod>();
    private String name;

    IcapMethod(String name) {
        this.name = name;
    }

    public static IcapMethod valueOf(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if ((name = name.trim().toUpperCase()).length() == 0) {
            throw new IllegalArgumentException("empty name");
        }
        IcapMethod result = METHOD_MAP.get(name);
        if (result != null) {
            return result;
        }
        return new IcapMethod(name);
    }

    public String toString() {
        return this.name;
    }

    static {
        METHOD_MAP.put(REQMOD.toString(), REQMOD);
        METHOD_MAP.put(RESPMOD.toString(), RESPMOD);
        METHOD_MAP.put(OPTIONS.toString(), OPTIONS);
    }
}

