/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IcapVersion {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\S+)/(\\d+)\\.(\\d+)");
    private String protocolName;
    private int major;
    private int minor;
    private String text;
    public static final IcapVersion ICAP_1_0 = new IcapVersion("ICAP", 1, 0);

    private IcapVersion(String protocolName, int major, int minor) {
        this.protocolName = protocolName;
        this.major = major;
        this.minor = minor;
        this.text = protocolName + '/' + major + '.' + minor;
    }

    private IcapVersion(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        Matcher m = VERSION_PATTERN.matcher(text.trim().toUpperCase());
        if (!m.matches()) {
            throw new IllegalArgumentException("invalid version format: [" + text + "]");
        }
        this.protocolName = m.group(1);
        this.major = Integer.parseInt(m.group(2));
        this.minor = Integer.parseInt(m.group(3));
        this.text = text;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public String getText() {
        return this.text;
    }

    public static IcapVersion valueOf(String text) {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (text.trim().toUpperCase().equals("ICAP/1.0")) {
            return ICAP_1_0;
        }
        return new IcapVersion(text);
    }

    public String toString() {
        return this.text;
    }
}

