/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import ch.mimo.netty.handler.codec.icap.DecodingException;
import ch.mimo.netty.handler.codec.icap.Encapsulated;
import ch.mimo.netty.handler.codec.icap.IcapDecoderUtil;
import ch.mimo.netty.handler.codec.icap.IcapMessageDecoder;
import ch.mimo.netty.handler.codec.icap.IcapMessageElementEnum;
import ch.mimo.netty.handler.codec.icap.State;
import ch.mimo.netty.handler.codec.icap.StateEnum;
import ch.mimo.netty.handler.codec.icap.StateReturnValue;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;

public class ReadHttpResponseInitalAndHeadersState
extends State<Object> {
    public ReadHttpResponseInitalAndHeadersState(String name) {
        super(name);
    }

    @Override
    public void onEntry(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder) throws DecodingException {
        if (icapMessageDecoder.message == null) {
            throw new IllegalArgumentException("This state requires a valid IcapMessage instance");
        }
        if (icapMessageDecoder.message.getEncapsulatedHeader() == null) {
            throw new IllegalArgumentException("This state requires a valid Encapsulation header instance");
        }
    }

    @Override
    public StateReturnValue execute(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder) throws DecodingException {
        String line = IcapDecoderUtil.readLine(buffer, icapMessageDecoder.maxInitialLineLength);
        String[] initialLine = IcapDecoderUtil.splitInitialLine(line);
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.valueOf((String)initialLine[0]), HttpResponseStatus.valueOf((int)Integer.parseInt(initialLine[1])));
        icapMessageDecoder.message.setHttpResponse((HttpResponse)message);
        List<String[]> headerList = IcapDecoderUtil.readHeaders(buffer, icapMessageDecoder.maxHttpHeaderSize);
        for (String[] header : headerList) {
            message.addHeader(header[0], (Object)header[1]);
        }
        Encapsulated encapsulated = icapMessageDecoder.message.getEncapsulatedHeader();
        encapsulated.setEntryAsProcessed(encapsulated.getNextEntry());
        if (encapsulated.getNextEntry() != null && encapsulated.getNextEntry().equals((Object)IcapMessageElementEnum.REQHDR)) {
            return StateReturnValue.createIrrelevantResult();
        }
        return StateReturnValue.createRelevantResult(icapMessageDecoder.message);
    }

    @Override
    public StateEnum onExit(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder, Object decisionInformation) throws DecodingException {
        Encapsulated encapsulated = icapMessageDecoder.message.getEncapsulatedHeader();
        IcapMessageElementEnum entry = encapsulated.getNextEntry();
        if (entry != null) {
            if (entry.equals((Object)IcapMessageElementEnum.REQHDR)) {
                return StateEnum.READ_HTTP_REQUEST_INITIAL_AND_HEADERS;
            }
            if (entry.equals((Object)IcapMessageElementEnum.REQBODY)) {
                return StateEnum.READ_CHUNK_SIZE_STATE;
            }
            if (entry.equals((Object)IcapMessageElementEnum.RESBODY)) {
                return StateEnum.READ_CHUNK_SIZE_STATE;
            }
        }
        return null;
    }
}

