/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import ch.mimo.netty.handler.codec.icap.DecodingException;
import ch.mimo.netty.handler.codec.icap.Encapsulated;
import ch.mimo.netty.handler.codec.icap.IcapDecoderUtil;
import ch.mimo.netty.handler.codec.icap.IcapDecodingError;
import ch.mimo.netty.handler.codec.icap.IcapMessage;
import ch.mimo.netty.handler.codec.icap.IcapMessageDecoder;
import ch.mimo.netty.handler.codec.icap.IcapMessageElementEnum;
import ch.mimo.netty.handler.codec.icap.IcapMethod;
import ch.mimo.netty.handler.codec.icap.IcapRequest;
import ch.mimo.netty.handler.codec.icap.State;
import ch.mimo.netty.handler.codec.icap.StateEnum;
import ch.mimo.netty.handler.codec.icap.StateReturnValue;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;

public class ReadIcapHeaderState
extends State<Object> {
    public ReadIcapHeaderState(String name) {
        super(name);
    }

    @Override
    public void onEntry(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder) throws DecodingException {
        if (icapMessageDecoder.message == null) {
            throw new IllegalArgumentException("This state requires a valid IcapMessage instance");
        }
    }

    @Override
    public StateReturnValue execute(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder) throws DecodingException {
        List<String[]> headerList = IcapDecoderUtil.readHeaders(buffer, icapMessageDecoder.maxIcapHeaderSize);
        icapMessageDecoder.message.clearHeaders();
        for (String[] header : headerList) {
            icapMessageDecoder.message.addHeader(header[0], header[1]);
        }
        boolean isRequest = icapMessageDecoder.message instanceof IcapRequest;
        boolean isOptionsRequest = isRequest && ((IcapRequest)icapMessageDecoder.message).getMethod().equals(IcapMethod.OPTIONS);
        this.validateMandatoryMessageHeaders(icapMessageDecoder.message, icapMessageDecoder.isDecodingResponse(), isOptionsRequest);
        Encapsulated encapsulated = null;
        String headerValue = icapMessageDecoder.message.getHeader("Encapsulated");
        if (headerValue != null) {
            encapsulated = new Encapsulated(icapMessageDecoder.message.getHeader("Encapsulated"));
            icapMessageDecoder.message.setEncapsulatedHeader(encapsulated);
        }
        if (isOptionsRequest) {
            return StateReturnValue.createRelevantResult(icapMessageDecoder.message);
        }
        if (encapsulated != null && !encapsulated.containsEntry(IcapMessageElementEnum.REQHDR) & !encapsulated.containsEntry(IcapMessageElementEnum.RESHDR)) {
            return StateReturnValue.createRelevantResult(icapMessageDecoder.message);
        }
        return StateReturnValue.createIrrelevantResult();
    }

    @Override
    public StateEnum onExit(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder, Object decisionInformation) throws DecodingException {
        IcapMessage message = icapMessageDecoder.message;
        Encapsulated encapsulated = message.getEncapsulatedHeader();
        if (message instanceof IcapRequest && ((IcapRequest)message).getMethod().equals(IcapMethod.OPTIONS)) {
            if (encapsulated != null && encapsulated.containsEntry(IcapMessageElementEnum.OPTBODY)) {
                return StateEnum.READ_CHUNK_SIZE_STATE;
            }
            return null;
        }
        IcapMessageElementEnum entry = encapsulated.getNextEntry();
        if (entry != null) {
            if (entry.equals((Object)IcapMessageElementEnum.REQHDR)) {
                return StateEnum.READ_HTTP_REQUEST_INITIAL_AND_HEADERS;
            }
            if (entry.equals((Object)IcapMessageElementEnum.RESHDR)) {
                return StateEnum.READ_HTTP_RESPONSE_INITIAL_AND_HEADERS;
            }
            if (entry.equals((Object)IcapMessageElementEnum.REQBODY)) {
                return StateEnum.READ_CHUNK_SIZE_STATE;
            }
            if (entry.equals((Object)IcapMessageElementEnum.RESBODY)) {
                return StateEnum.READ_CHUNK_SIZE_STATE;
            }
        }
        return null;
    }

    private void validateMandatoryMessageHeaders(IcapMessage message, boolean isDecodingResponse, boolean isDecodingOptionsRequest) {
        if (!isDecodingResponse && !message.containsHeader("Host")) {
            throw new IcapDecodingError("Mandatory ICAP message header [Host] is missing");
        }
        if (!isDecodingOptionsRequest && !message.containsHeader("Encapsulated")) {
            throw new IcapDecodingError("Mandatory ICAP message header [Encapsulated] is missing");
        }
    }
}

