/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import ch.mimo.netty.handler.codec.icap.DecodingException;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;

public class SizeDelimiter {
    private int counter = 0;
    private int limit;
    private String errorMessage;

    public SizeDelimiter(int limit) {
        this.limit = limit;
        this.errorMessage = "limit exeeded by: ";
    }

    public synchronized void increment(int count) throws DecodingException {
        this.counter += count;
        this.checkLimit();
    }

    public void increment() throws DecodingException {
        this.increment(1);
    }

    public int getSize() {
        return this.counter;
    }

    private void checkLimit() throws DecodingException {
        if (this.counter >= this.limit) {
            throw new DecodingException((Throwable)new TooLongFrameException(this.errorMessage + "[" + (this.counter - this.limit) + "] counts"));
        }
    }
}

