/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

public class StateReturnValue {
    private boolean relevance;
    private Object value;
    private Object decisionInformation;

    public StateReturnValue(boolean relevance, Object value, Object decisionInformation) {
        this.relevance = relevance;
        this.value = value;
        this.decisionInformation = decisionInformation;
    }

    public static StateReturnValue createIrrelevantResult() {
        return new StateReturnValue(false, null, null);
    }

    public static StateReturnValue createIrrelevantResultWithDecisionInformation(Object decisionInformation) {
        return new StateReturnValue(false, null, decisionInformation);
    }

    public static StateReturnValue createRelevantResult(Object result) {
        return new StateReturnValue(true, result, null);
    }

    public static StateReturnValue createRelevantResultWithDecisionInformation(Object result, Object decisionInformation) {
        return new StateReturnValue(true, result, decisionInformation);
    }

    public boolean isRelevant() {
        return this.relevance;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getDecisionInformation() {
        return this.decisionInformation;
    }

    public String toString() {
        String printValue = "null";
        if (this.value != null) {
            printValue = this.value.getClass().getCanonicalName();
        }
        return "StateReturnValue: [relevance=" + this.relevance + "] [value=" + printValue + "] [decision information=" + this.decisionInformation + "]";
    }
}

