/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import ch.mimo.netty.handler.codec.icap.IcapCodecUtil;
import ch.mimo.netty.handler.codec.icap.IcapDecodingError;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class IcapHeaders {
    private Entry base;
    private Entry head;

    public void clearHeaders() {
        this.base = null;
        this.head = null;
    }

    public void addHeader(String name, Object value) {
        Entry entry = new Entry(name, value);
        if (this.base == null) {
            this.base = entry;
            this.head = entry;
        } else {
            Entry currentHead = this.head;
            this.head = entry;
            entry.before = currentHead;
            currentHead.after = entry;
        }
    }

    public void setHeader(String name, Object value) {
        this.removeHeader(name);
        this.addHeader(name, value);
    }

    public void setHeader(String name, Iterable<?> values) {
        this.removeHeader(name);
        for (Object value : values) {
            this.addHeader(name, value);
        }
    }

    public String getHeader(String name) {
        Entry entry = this.base;
        while (entry != null) {
            if (this.identicalKeys(entry.getKey(), name)) {
                return entry.getValue();
            }
            entry = entry.after;
        }
        return null;
    }

    public Set<String> getHeaders(String name) {
        LinkedHashSet<String> values = new LinkedHashSet<String>();
        Entry entry = this.base;
        while (entry != null) {
            if (this.identicalKeys(entry.getKey(), name)) {
                values.add(entry.getValue());
            }
            entry = entry.after;
        }
        return values;
    }

    public Set<Map.Entry<String, String>> getHeaders() {
        LinkedHashSet<Map.Entry<String, String>> headers = new LinkedHashSet<Map.Entry<String, String>>();
        Entry entry = this.base;
        while (entry != null) {
            headers.add(entry);
            entry = entry.after;
        }
        return headers;
    }

    public boolean containsHeader(String name) {
        return this.getHeader(name) != null;
    }

    public void removeHeader(String name) {
        if (this.base == null) {
            return;
        }
        Entry entry = null;
        if (this.base.after == null) {
            if (this.identicalKeys(this.base.getKey(), name)) {
                this.base = null;
                return;
            }
        } else {
            entry = this.base.after;
        }
        while (entry != null) {
            if (this.identicalKeys(entry.getKey(), name)) {
                Entry before = entry.before;
                Entry after = entry.after;
                before.after = after;
                after.before = before;
                entry = after;
                continue;
            }
            entry = entry.after;
        }
        if (this.identicalKeys(this.base.getKey(), name)) {
            this.base = this.base.after;
            this.base.before = null;
        }
    }

    public Set<String> getHeaderNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        Entry entry = this.base;
        while (entry != null) {
            names.add(entry.getKey());
            entry = entry.after;
        }
        return names;
    }

    public int getPreviewHeaderValue() {
        String value = this.getHeader("Preview");
        int result = 0;
        try {
            if (value != null) {
                result = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException nfe) {
            throw new IcapDecodingError("Unable to understand the preview amount value [" + value + "]");
        }
        return result;
    }

    private boolean identicalKeys(String key1, String key2) {
        if (key1 != null & key2 != null) {
            return key1.equalsIgnoreCase(key2);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String name : this.getHeaderNames()) {
            builder.append("[" + name + "] = [" + this.getHeaders(name) + "]");
        }
        return builder.toString();
    }

    private static final class Entry
    implements Map.Entry<String, String> {
        private String key;
        private String value;
        private Entry before;
        private Entry after;

        Entry(String key, Object value) {
            IcapCodecUtil.validateHeaderName(key);
            this.key = key;
            if (value != null) {
                this.value = value.toString();
                IcapCodecUtil.validateHeaderValue(this.value);
            }
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            return null;
        }
    }

    public static final class Names {
        public static final String CACHE_CONTROL = "Cache-Control";
        public static final String CONNECTION = "Connection";
        public static final String DATE = "Date";
        public static final String EXPIRES = "Expires";
        public static final String PRAGMA = "Pragma";
        public static final String TRAILER = "Trailer";
        public static final String UPGRADE = "Upgrade";
        public static final String ENCAPSULATED = "Encapsulated";
        public static final String AUTHORIZATION = "Authorization";
        public static final String ALLOW = "Allow";
        public static final String FROM = "From";
        public static final String HOST = "Host";
        public static final String REFERER = "Referer";
        public static final String USER_AGENT = "User-Agent";
        public static final String PREVIEW = "Preview";
        public static final String ISTAG = "ISTag";
    }
}

