/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import ch.mimo.netty.handler.codec.icap.DecodingException;
import ch.mimo.netty.handler.codec.icap.IcapMessage;
import ch.mimo.netty.handler.codec.icap.State;
import ch.mimo.netty.handler.codec.icap.StateEnum;
import ch.mimo.netty.handler.codec.icap.StateReturnValue;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

public abstract class IcapMessageDecoder
extends ReplayingDecoder<StateEnum> {
    private final InternalLogger LOG = InternalLoggerFactory.getInstance(((Object)((Object)this)).getClass());
    protected final int maxInitialLineLength;
    protected final int maxIcapHeaderSize;
    protected final int maxHttpHeaderSize;
    protected final int maxChunkSize;
    protected IcapMessage message;
    protected int currentChunkSize;

    protected IcapMessageDecoder() {
        this(4096, 8192, 8192, 8192);
    }

    protected IcapMessageDecoder(int maxInitialLineLength, int maxIcapHeaderSize, int maxHttpHeaderSize, int maxChunkSize) {
        super((Enum)StateEnum.SKIP_CONTROL_CHARS, true);
        if (maxInitialLineLength <= 0) {
            throw new IllegalArgumentException("maxInitialLineLength must be a positive integer: " + maxInitialLineLength);
        }
        if (maxIcapHeaderSize <= 0) {
            throw new IllegalArgumentException("maxIcapHeaderSize must be a positive integer: " + maxIcapHeaderSize);
        }
        if (maxHttpHeaderSize <= 0) {
            throw new IllegalArgumentException("maxHttpHeaderSize must be a positive integer: " + maxIcapHeaderSize);
        }
        if (maxChunkSize <= 0) {
            throw new IllegalArgumentException("maxChunkSize must be a positive integer: " + maxChunkSize);
        }
        this.maxInitialLineLength = maxInitialLineLength;
        this.maxIcapHeaderSize = maxIcapHeaderSize;
        this.maxHttpHeaderSize = maxHttpHeaderSize;
        this.maxChunkSize = maxChunkSize;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, StateEnum stateEnumValue) throws Exception {
        if (stateEnumValue != null) {
            try {
                State<? extends Object> state = stateEnumValue.getState();
                this.LOG.debug("Executing state [" + state + ']');
                state.onEntry(buffer, this);
                StateReturnValue returnValue = state.execute(buffer, this);
                this.LOG.debug("Return value from state [" + state + "] = [" + returnValue + "]");
                StateEnum nextState = state.onExit(buffer, this, returnValue.getDecisionInformation());
                this.LOG.debug("Next State [" + (Object)((Object)nextState) + "]");
                if (nextState != null) {
                    this.checkpoint(nextState);
                } else {
                    this.reset();
                }
                if (returnValue.isRelevant()) {
                    return returnValue.getValue();
                }
            }
            catch (DecodingException e) {
                this.reset();
                throw e;
            }
        }
        return null;
    }

    private void reset() {
        this.message = null;
        this.checkpoint(StateEnum.SKIP_CONTROL_CHARS);
    }

    public abstract boolean isDecodingResponse();

    protected abstract IcapMessage createMessage(String[] var1);
}

