/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import ch.mimo.netty.handler.codec.icap.IcapChunk;
import ch.mimo.netty.handler.codec.icap.IcapChunkTrailer;
import ch.mimo.netty.handler.codec.icap.IcapDecodingError;
import ch.mimo.netty.handler.codec.icap.IcapMessage;
import ch.mimo.netty.handler.codec.icap.IcapMessageElementEnum;
import ch.mimo.netty.handler.codec.icap.IcapResponse;
import java.net.SocketAddress;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;

public class IcapChunkAggregator
extends SimpleChannelUpstreamHandler {
    private static final InternalLogger LOG = InternalLoggerFactory.getInstance(IcapChunkAggregator.class);
    private long maxContentLength;
    private IcapMessageWrapper message;

    public static ChannelBuffer extractHttpBodyContentFromIcapMessage(IcapMessage message) {
        ChannelBuffer buffer = null;
        if (message.getBodyType().equals((Object)IcapMessageElementEnum.REQBODY) && message.getHttpRequest() != null) {
            buffer = message.getHttpRequest().getContent();
        } else if (message.getBodyType().equals((Object)IcapMessageElementEnum.RESBODY) && message.getHttpResponse() != null) {
            buffer = message.getHttpResponse().getContent();
        } else if (message instanceof IcapResponse && message.getBodyType().equals((Object)IcapMessageElementEnum.OPTBODY)) {
            IcapResponse response = (IcapResponse)message;
            buffer = response.getContent();
        }
        return buffer;
    }

    public IcapChunkAggregator(long maxContentLength) {
        this.maxContentLength = maxContentLength;
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof IcapMessage) {
            LOG.debug("Aggregation of message [" + msg.getClass().getName() + "] ");
            IcapMessage currentMessage = (IcapMessage)msg;
            this.message = new IcapMessageWrapper(currentMessage);
            if (!this.message.hasBody()) {
                Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)this.message.getIcapMessage(), (SocketAddress)e.getRemoteAddress());
                this.message = null;
                return;
            }
        } else if (msg instanceof IcapChunkTrailer) {
            LOG.debug("Aggregation of chunk trailer [" + msg.getClass().getName() + "] ");
            if (this.message == null) {
                ctx.sendUpstream((ChannelEvent)e);
            } else {
                IcapChunkTrailer trailer = (IcapChunkTrailer)msg;
                if (trailer.getHeaderNames().size() > 0) {
                    for (String name : trailer.getHeaderNames()) {
                        this.message.addHeader(name, trailer.getHeader(name));
                    }
                }
                Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)this.message.getIcapMessage(), (SocketAddress)e.getRemoteAddress());
            }
        } else if (msg instanceof IcapChunk) {
            LOG.debug("Aggregation of chunk [" + msg.getClass().getName() + "] ");
            IcapChunk chunk = (IcapChunk)msg;
            if (this.message == null) {
                ctx.sendUpstream((ChannelEvent)e);
            } else if (chunk.isLast()) {
                Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)this.message.getIcapMessage(), (SocketAddress)e.getRemoteAddress());
                this.message = null;
            } else {
                ChannelBuffer chunkBuffer = chunk.getContent();
                ChannelBuffer content = this.message.getContent();
                if ((long)content.readableBytes() > this.maxContentLength - (long)chunkBuffer.readableBytes()) {
                    throw new TooLongFrameException("ICAP content length exceeded [" + this.maxContentLength + "] bytes");
                }
                content.writeBytes(chunkBuffer);
            }
        } else {
            ctx.sendUpstream((ChannelEvent)e);
        }
    }

    private final class IcapMessageWrapper {
        private IcapMessage message;
        private HttpMessage relevantHttpMessage;
        private IcapResponse icapResponse;
        private boolean messageWithBody;

        public IcapMessageWrapper(IcapMessage message) {
            this.message = message;
            if (message.getBodyType() != null) {
                if (message.getBodyType().equals((Object)IcapMessageElementEnum.REQBODY)) {
                    this.relevantHttpMessage = message.getHttpRequest();
                    this.messageWithBody = true;
                } else if (message.getBodyType().equals((Object)IcapMessageElementEnum.RESBODY)) {
                    this.relevantHttpMessage = message.getHttpResponse();
                    this.messageWithBody = true;
                } else if (message instanceof IcapResponse && message.getBodyType().equals((Object)IcapMessageElementEnum.OPTBODY)) {
                    this.icapResponse = (IcapResponse)message;
                    this.messageWithBody = true;
                }
            }
            if (this.messageWithBody) {
                if (this.relevantHttpMessage != null) {
                    if (this.relevantHttpMessage.getContent() == null || this.relevantHttpMessage.getContent().readableBytes() <= 0) {
                        this.relevantHttpMessage.setContent(ChannelBuffers.dynamicBuffer());
                    }
                } else if (this.icapResponse != null && (this.icapResponse.getContent() == null || this.icapResponse.getContent().readableBytes() <= 0)) {
                    this.icapResponse.setContent(ChannelBuffers.dynamicBuffer());
                }
            }
        }

        public boolean hasBody() {
            return this.messageWithBody;
        }

        public IcapMessage getIcapMessage() {
            return this.message;
        }

        public void addHeader(String name, String value) {
            if (!this.messageWithBody) {
                throw new IcapDecodingError("A message without body cannot carry trailing headers.");
            }
            this.relevantHttpMessage.addHeader(name, (Object)value);
        }

        public ChannelBuffer getContent() {
            if (this.messageWithBody) {
                if (this.relevantHttpMessage != null) {
                    return this.relevantHttpMessage.getContent();
                }
                if (this.icapResponse != null) {
                    return this.icapResponse.getContent();
                }
            }
            throw new IcapDecodingError("Message stated that there is a body but nothing found in message.");
        }
    }
}

