/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import ch.mimo.netty.handler.codec.icap.DecodingException;
import ch.mimo.netty.handler.codec.icap.DefaultIcapChunkTrailer;
import ch.mimo.netty.handler.codec.icap.IcapDecoderUtil;
import ch.mimo.netty.handler.codec.icap.IcapMessageDecoder;
import ch.mimo.netty.handler.codec.icap.State;
import ch.mimo.netty.handler.codec.icap.StateEnum;
import ch.mimo.netty.handler.codec.icap.StateReturnValue;
import org.jboss.netty.buffer.ChannelBuffer;

public class ReadChunkSizeState
extends State<DecisionState> {
    public ReadChunkSizeState(String name) {
        super(name);
    }

    @Override
    public void onEntry(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder) throws DecodingException {
    }

    @Override
    public StateReturnValue execute(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder) throws DecodingException {
        int chunkSize = 0;
        String previewLine = IcapDecoderUtil.previewLine(buffer, icapMessageDecoder.maxInitialLineLength);
        try {
            chunkSize = IcapDecoderUtil.getChunkSize(previewLine);
            IcapDecoderUtil.readLine(buffer, icapMessageDecoder.maxInitialLineLength);
        }
        catch (DecodingException de) {
            return StateReturnValue.createIrrelevantResultWithDecisionInformation((Object)DecisionState.RESET);
        }
        icapMessageDecoder.currentChunkSize = chunkSize;
        if (chunkSize > 0) {
            if (chunkSize >= icapMessageDecoder.maxChunkSize) {
                return StateReturnValue.createIrrelevantResultWithDecisionInformation((Object)DecisionState.READ_HUGE_CHUNK_IN_SMALER_CHUNKS);
            }
            return StateReturnValue.createIrrelevantResultWithDecisionInformation((Object)DecisionState.READ_CHUNK);
        }
        if (chunkSize == -1) {
            icapMessageDecoder.currentChunkSize = 0;
            IcapDecoderUtil.readLine(buffer, Integer.MAX_VALUE);
            return StateReturnValue.createRelevantResultWithDecisionInformation(new DefaultIcapChunkTrailer(true, true), (Object)DecisionState.IS_LAST_PREVIEW_CHUNK);
        }
        if (chunkSize == 0) {
            if (!this.checkForLineBreak(buffer)) {
                return StateReturnValue.createIrrelevantResultWithDecisionInformation((Object)DecisionState.READ_TRAILING_HEADERS);
            }
            IcapDecoderUtil.readLine(buffer, 10);
            if (icapMessageDecoder.message.isPreviewMessage()) {
                return StateReturnValue.createRelevantResultWithDecisionInformation(new DefaultIcapChunkTrailer(true, false), (Object)DecisionState.IS_LAST_PREVIEW_CHUNK);
            }
            return StateReturnValue.createRelevantResultWithDecisionInformation(new DefaultIcapChunkTrailer(icapMessageDecoder.message.isPreviewMessage(), false), (Object)DecisionState.IS_LAST_CHUNK);
        }
        return StateReturnValue.createIrrelevantResultWithDecisionInformation((Object)DecisionState.RESET);
    }

    @Override
    public StateEnum onExit(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder, DecisionState decisionInformation) throws DecodingException {
        return decisionInformation.getNextState();
    }

    private boolean checkForLineBreak(ChannelBuffer buffer) {
        byte previewByte = buffer.getByte(buffer.readerIndex() + 1);
        return previewByte == 13 | previewByte == 10;
    }

    public static enum DecisionState {
        READ_CHUNK(StateEnum.READ_CHUNK_STATE),
        READ_HUGE_CHUNK_IN_SMALER_CHUNKS(StateEnum.READ_CHUNKED_CONTENT_AS_CHUNKS_STATE),
        READ_TRAILING_HEADERS(StateEnum.READ_TRAILING_HEADERS_STATE),
        IS_LAST_PREVIEW_CHUNK(StateEnum.READ_CHUNK_SIZE_STATE),
        IS_LAST_CHUNK(StateEnum.SKIP_CONTROL_CHARS),
        RESET(null);

        private StateEnum state;

        private DecisionState(StateEnum nextState) {
            this.state = nextState;
        }

        public StateEnum getNextState() {
            return this.state;
        }
    }
}

