/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import ch.mimo.netty.handler.codec.icap.DecodingException;
import ch.mimo.netty.handler.codec.icap.DefaultIcapChunkTrailer;
import ch.mimo.netty.handler.codec.icap.IcapDecoderUtil;
import ch.mimo.netty.handler.codec.icap.IcapMessageDecoder;
import ch.mimo.netty.handler.codec.icap.SizeDelimiter;
import ch.mimo.netty.handler.codec.icap.State;
import ch.mimo.netty.handler.codec.icap.StateEnum;
import ch.mimo.netty.handler.codec.icap.StateReturnValue;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;

public class ReadTrailingHeadersState
extends State<Object> {
    public ReadTrailingHeadersState(String name) {
        super(name);
    }

    @Override
    public void onEntry(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder) throws DecodingException {
    }

    @Override
    public StateReturnValue execute(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder) throws DecodingException {
        SizeDelimiter sizeDelimiter = new SizeDelimiter(icapMessageDecoder.maxHttpHeaderSize);
        boolean preview = icapMessageDecoder.message.isPreviewMessage();
        String line = IcapDecoderUtil.readSingleHeaderLine(buffer, sizeDelimiter);
        String lastHeader = null;
        if (line.length() != 0) {
            DefaultIcapChunkTrailer trailer = new DefaultIcapChunkTrailer(preview, false);
            do {
                char firstChar = line.charAt(0);
                if (lastHeader != null && (firstChar == ' ' || firstChar == '\t')) {
                    List current = trailer.getHeaders(lastHeader);
                    if (current.size() == 0) continue;
                    int lastPos = current.size() - 1;
                    String newString = (String)current.get(lastPos) + line.trim();
                    current.set(lastPos, newString);
                    continue;
                }
                String[] header = IcapDecoderUtil.splitHeader(line);
                String name = header[0];
                if (!(name.equalsIgnoreCase("Content-Length") || name.equalsIgnoreCase("Transfer-Encoding") || name.equalsIgnoreCase("Trailer"))) {
                    trailer.addHeader(name, header[1]);
                }
                lastHeader = name;
            } while ((line = IcapDecoderUtil.readSingleHeaderLine(buffer, sizeDelimiter)).length() != 0);
            return StateReturnValue.createRelevantResult(trailer);
        }
        return StateReturnValue.createRelevantResult(new DefaultIcapChunkTrailer(preview, false));
    }

    @Override
    public StateEnum onExit(ChannelBuffer buffer, IcapMessageDecoder icapMessageDecoder, Object decisionInformation) throws DecodingException {
        return null;
    }
}

