/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import ch.mimo.netty.handler.codec.icap.IcapCodecUtil;
import ch.mimo.netty.handler.codec.icap.IcapDecodingError;
import ch.mimo.netty.handler.codec.icap.IcapMessageElementEnum;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jboss.netty.buffer.ChannelBuffer;

public final class Encapsulated {
    private List<Entry> entries = new ArrayList<Entry>();

    public Encapsulated() {
    }

    public Encapsulated(String headerValue) {
        this();
        this.parseHeaderValue(headerValue);
    }

    public boolean containsEntry(IcapMessageElementEnum entity) {
        for (Entry entry : this.entries) {
            if (!entry.getName().equals((Object)entity)) continue;
            return true;
        }
        return false;
    }

    public IcapMessageElementEnum containsBodyEntry() {
        IcapMessageElementEnum body = null;
        for (Entry entry : this.entries) {
            if (entry.getName().equals((Object)IcapMessageElementEnum.OPTBODY)) {
                body = entry.getName();
                break;
            }
            if (entry.getName().equals((Object)IcapMessageElementEnum.REQBODY)) {
                body = entry.getName();
                break;
            }
            if (entry.getName().equals((Object)IcapMessageElementEnum.RESBODY)) {
                body = entry.getName();
                break;
            }
            if (!entry.getName().equals((Object)IcapMessageElementEnum.NULLBODY)) continue;
            body = entry.getName();
            break;
        }
        return body;
    }

    public IcapMessageElementEnum getNextEntry() {
        IcapMessageElementEnum entryName = null;
        for (Entry entry : this.entries) {
            if (entry.isProcessed()) continue;
            entryName = entry.getName();
            break;
        }
        return entryName;
    }

    public void setEntryAsProcessed(IcapMessageElementEnum entryName) {
        Entry entry = this.getEntryByName(entryName);
        if (entry != null) {
            entry.setIsProcessed();
        }
    }

    public void addEntry(IcapMessageElementEnum name, int position) {
        Entry entry = new Entry(name, position);
        this.entries.add(entry);
    }

    public int encode(ChannelBuffer buffer) throws UnsupportedEncodingException {
        int index = buffer.readableBytes();
        Collections.sort(this.entries);
        buffer.writeBytes("Encapsulated: ".getBytes(IcapCodecUtil.ASCII_CHARSET));
        Iterator<Entry> entryIterator = this.entries.iterator();
        while (entryIterator.hasNext()) {
            Entry entry = entryIterator.next();
            buffer.writeBytes(entry.getName().getValue().getBytes(IcapCodecUtil.ASCII_CHARSET));
            buffer.writeBytes("=".getBytes(IcapCodecUtil.ASCII_CHARSET));
            buffer.writeBytes(Integer.toString(entry.getPosition()).getBytes(IcapCodecUtil.ASCII_CHARSET));
            if (!entryIterator.hasNext()) continue;
            buffer.writeByte(44);
            buffer.writeByte(32);
        }
        buffer.writeBytes(IcapCodecUtil.CRLF);
        buffer.writeBytes(IcapCodecUtil.CRLF);
        return buffer.readableBytes() - index;
    }

    private void parseHeaderValue(String headerValue) {
        if (headerValue == null) {
            throw new IcapDecodingError("No value associated with Encapsualted header");
        }
        StringTokenizer tokenizer = new StringTokenizer(headerValue, ",");
        while (tokenizer.hasMoreTokens()) {
            String parameterString = tokenizer.nextToken();
            if (parameterString == null) continue;
            String[] parameter = this.splitParameter(parameterString.trim());
            try {
                int value = Integer.parseInt(parameter[1]);
                Entry entry = new Entry(IcapMessageElementEnum.fromString(parameter[0]), value);
                this.entries.add(entry);
            }
            catch (NumberFormatException nfe) {
                throw new IcapDecodingError("the Encapsulated header value [" + parameter[1] + "] for the key [" + parameter[0] + "] is not a number");
            }
        }
        Collections.sort(this.entries);
    }

    private String[] splitParameter(String parameter) {
        int offset = parameter.indexOf(61);
        if (offset <= 0) {
            throw new IcapDecodingError("Encapsulated header value was not understood [" + parameter + "]");
        }
        String key = parameter.substring(0, offset);
        String value = parameter.substring(offset + 1, parameter.length());
        if (value.contains(",")) {
            value = value.substring(0, value.indexOf(44));
        }
        return new String[]{key.trim(), value};
    }

    private Entry getEntryByName(IcapMessageElementEnum entryName) {
        Entry returnValue = null;
        for (Entry entry : this.entries) {
            if (!entry.getName().equals((Object)entryName)) continue;
            returnValue = entry;
            break;
        }
        return returnValue;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Encapsulated: ");
        for (Entry entry : this.entries) {
            if (entry == null) continue;
            builder.append(" [").append(entry.toString()).append("] ");
        }
        return builder.toString();
    }

    private static final class Entry
    implements Comparable<Entry> {
        private final IcapMessageElementEnum name;
        private final Integer position;
        private boolean processed;

        public Entry(IcapMessageElementEnum name, Integer position) {
            this.name = name;
            this.position = position;
        }

        public IcapMessageElementEnum getName() {
            return this.name;
        }

        public int getPosition() {
            return this.position;
        }

        public void setIsProcessed() {
            this.processed = true;
        }

        public boolean isProcessed() {
            return this.processed;
        }

        @Override
        public int compareTo(Entry entry) {
            if (this.name.equals((Object)IcapMessageElementEnum.NULLBODY)) {
                return 1;
            }
            return this.position.compareTo(entry.position);
        }

        public String toString() {
            return (Object)((Object)this.name) + "=" + this.position + " : " + this.processed;
        }
    }
}

