/*
 * Decompiled with CFR 0.152.
 */
package ch.mimo.netty.handler.codec.icap;

import ch.mimo.netty.handler.codec.icap.Encapsulated;
import ch.mimo.netty.handler.codec.icap.IcapHeaders;
import ch.mimo.netty.handler.codec.icap.IcapMessage;
import ch.mimo.netty.handler.codec.icap.IcapMessageElementEnum;
import ch.mimo.netty.handler.codec.icap.IcapVersion;
import java.util.Map;
import java.util.Set;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.util.internal.StringUtil;

public abstract class AbstractIcapMessage
implements IcapMessage {
    private IcapHeaders icapHeader;
    private IcapVersion version;
    private Encapsulated encapsulated;
    private HttpRequest httpRequest;
    private HttpResponse httpResponse;
    private IcapMessageElementEnum body;

    public AbstractIcapMessage(IcapVersion version) {
        this.version = version;
        this.icapHeader = new IcapHeaders();
    }

    @Override
    public String getHeader(String name) {
        return this.icapHeader.getHeader(name);
    }

    @Override
    public Set<String> getHeaders(String name) {
        return this.icapHeader.getHeaders(name);
    }

    @Override
    public Set<Map.Entry<String, String>> getHeaders() {
        return this.icapHeader.getHeaders();
    }

    @Override
    public boolean containsHeader(String name) {
        return this.icapHeader.containsHeader(name);
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.icapHeader.getHeaderNames();
    }

    @Override
    public IcapMessage addHeader(String name, Object value) {
        this.icapHeader.addHeader(name, value);
        return this;
    }

    @Override
    public IcapMessage setHeader(String name, Object value) {
        this.icapHeader.setHeader(name, value);
        return this;
    }

    @Override
    public IcapMessage setHeader(String name, Iterable<?> values) {
        this.icapHeader.setHeader(name, values);
        return this;
    }

    @Override
    public IcapMessage removeHeader(String name) {
        this.icapHeader.removeHeader(name);
        return this;
    }

    @Override
    public int getPreviewAmount() {
        return this.icapHeader.getPreviewHeaderValue();
    }

    @Override
    public IcapMessage clearHeaders() {
        this.icapHeader.clearHeaders();
        return this;
    }

    @Override
    public IcapVersion getProtocolVersion() {
        return this.version;
    }

    @Override
    public IcapMessage setProtocolVersion(IcapVersion version) {
        this.version = version;
        return this;
    }

    @Override
    public boolean containsHttpRequest() {
        return this.httpRequest != null;
    }

    @Override
    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public IcapMessage setHttpRequest(HttpRequest httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    @Override
    public boolean containsHttpResponse() {
        return this.httpResponse != null;
    }

    @Override
    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    @Override
    public IcapMessage setHttpResponse(HttpResponse response) {
        this.httpResponse = response;
        return this;
    }

    @Override
    public IcapMessage setEncapsulatedHeader(Encapsulated encapsulated) {
        this.encapsulated = encapsulated;
        return this;
    }

    @Override
    public Encapsulated getEncapsulatedHeader() {
        return this.encapsulated;
    }

    @Override
    public boolean isPreviewMessage() {
        return this.icapHeader.getPreviewHeaderValue() > 0;
    }

    @Override
    public IcapMessage setBody(IcapMessageElementEnum body) {
        this.body = body;
        return this;
    }

    @Override
    public IcapMessageElementEnum getBodyType() {
        if (this.encapsulated != null) {
            return this.encapsulated.containsBodyEntry();
        }
        return this.body;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(version: ");
        buf.append(this.getProtocolVersion().getText());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        if (this.httpRequest != null) {
            buf.append("--- encapsulated HTTP Request ---").append(StringUtil.NEWLINE);
            buf.append(this.httpRequest.toString());
            if (this.httpRequest.getContent() != null && this.httpRequest.getContent().readableBytes() > 0) {
                buf.append(StringUtil.NEWLINE).append("--> HTTP Request contains [" + this.httpRequest.getContent().readableBytes() + "] bytes of data").append(StringUtil.NEWLINE);
            }
        }
        if (this.httpResponse != null) {
            buf.append("--- encapsulated HTTP Response ---").append(StringUtil.NEWLINE);
            buf.append(this.httpResponse.toString());
            if (this.httpResponse.getContent() != null && this.httpResponse.getContent().readableBytes() > 0) {
                buf.append(StringUtil.NEWLINE).append("--> HTTP Response contains [" + this.httpResponse.getContent().readableBytes() + "] bytes of data").append(StringUtil.NEWLINE);
            }
        }
        if (this.isPreviewMessage()) {
            buf.append("--- Preview ---").append(StringUtil.NEWLINE);
            buf.append("Preview size: " + this.icapHeader.getPreviewHeaderValue());
        }
        return buf.toString();
    }

    private void appendHeaders(StringBuilder buf) {
        for (Map.Entry<String, String> e : this.getHeaders()) {
            buf.append(e.getKey());
            buf.append(": ");
            buf.append(e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }
}

