/*
 * Decompiled with CFR 0.152.
 */
package ch.miranet.rdfstructure;

import ch.miranet.rdfstructure.RdfStructureBuilder;
import ch.miranet.rdfstructure.RdfsClass;
import ch.miranet.rdfstructure.StructuralElement;
import java.util.function.BiConsumer;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.ModelBuilder;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SHACL;

public class PropertyShape
extends StructuralElement<Resource> {
    public PropertyShape(RdfStructureBuilder structBuilder, Resource propertyShapeResource) {
        super(structBuilder, propertyShapeResource);
    }

    public PropertyShape label(String label) {
        this.b.modelBuilder.subject(this.resource).add(RDFS.LABEL, (Object)label);
        return this;
    }

    public PropertyShape comment(String comment) {
        this.b.modelBuilder.subject(this.resource).add(RDFS.COMMENT, (Object)comment);
        return this;
    }

    public PropertyShape minCount(int count) {
        this.b.modelBuilder.subject(this.resource).add(SHACL.MIN_COUNT, (Object)count);
        return this;
    }

    public PropertyShape maxCount(int count) {
        this.b.modelBuilder.subject(this.resource).add(SHACL.MAX_COUNT, (Object)count);
        return this;
    }

    public PropertyShape count(int count) {
        return this.minCount(count).maxCount(count);
    }

    public PropertyShape clazz(RdfsClass cls) {
        return this.clazz((IRI)cls.resource);
    }

    public PropertyShape clazz(String prefixedNameOrIri) {
        return this.clazz(this.b.mapToIRI(prefixedNameOrIri));
    }

    public PropertyShape clazz(IRI iri) {
        this.b.modelBuilder.subject(this.resource).add(SHACL.CLASS, (Object)iri);
        return this;
    }

    public PropertyShape any(BiConsumer<ModelBuilder, Resource> consumer) {
        super.any(consumer);
        return this;
    }
}

