/*
 * Decompiled with CFR 0.152.
 */
package ch.miranet.rdfstructure;

import ch.miranet.rdfstructure.PropertyShape;
import ch.miranet.rdfstructure.RdfProperty;
import ch.miranet.rdfstructure.RdfStructureBuilder;
import ch.miranet.rdfstructure.RdfsClass;
import ch.miranet.rdfstructure.StructuralElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.ModelBuilder;
import org.eclipse.rdf4j.model.util.RDFCollections;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SHACL;

public class NodeShape
extends StructuralElement<Resource> {
    public NodeShape(RdfStructureBuilder structBuilder, Resource nodeShapeResource) {
        super(structBuilder, nodeShapeResource);
    }

    public NodeShape label(String label) {
        this.b.modelBuilder.subject(this.resource).add(RDFS.LABEL, (Object)label);
        return this;
    }

    public NodeShape comment(String comment) {
        this.b.modelBuilder.subject(this.resource).add(RDFS.COMMENT, (Object)comment);
        return this;
    }

    public NodeShape targetClass(RdfsClass targetClass) {
        return this.targetClass((IRI)targetClass.resource);
    }

    public NodeShape targetClass(String targetClassPrefixedNameOrIri) {
        return this.targetClass(this.b.mapToIRI(targetClassPrefixedNameOrIri));
    }

    public NodeShape targetClass(IRI targetClassIri) {
        this.b.modelBuilder.subject(this.resource).add(SHACL.TARGET_CLASS, (Object)targetClassIri);
        return this;
    }

    public NodeShape property(RdfProperty property, Consumer<PropertyShape> propertyShapeConsumer) {
        return this.property((IRI)property.resource, propertyShapeConsumer);
    }

    public NodeShape property(String propertyPrefixedNameOrIri, Consumer<PropertyShape> propertyShapeConsumer) {
        return this.property(this.b.mapToIRI(propertyPrefixedNameOrIri), propertyShapeConsumer);
    }

    public NodeShape property(IRI propertyIri, Consumer<PropertyShape> propertyShapeConsumer) {
        PropertyShape propertyShape = this.property0(propertyIri);
        propertyShapeConsumer.accept(propertyShape);
        return this;
    }

    public NodeShape property(RdfProperty property) {
        this.property0((IRI)property.resource);
        return this;
    }

    public NodeShape property(String propertyPrefixedNameOrIri) {
        this.property0(this.b.mapToIRI(propertyPrefixedNameOrIri));
        return this;
    }

    public NodeShape property(IRI propertyIri) {
        this.property0(propertyIri);
        return this;
    }

    protected NodeShape property(String propertyShapePrefixedNameOrIri, RdfProperty property, Consumer<PropertyShape> propertyShapeConsumer) {
        return this.property(this.b.mapToIRI(propertyShapePrefixedNameOrIri), (IRI)property.resource, propertyShapeConsumer);
    }

    protected NodeShape property(String propertyShapePrefixedNameOrIri, String propertyPrefixedNameOrIri, Consumer<PropertyShape> propertyShapeConsumer) {
        return this.property(this.b.mapToIRI(propertyShapePrefixedNameOrIri), this.b.mapToIRI(propertyPrefixedNameOrIri), propertyShapeConsumer);
    }

    protected NodeShape property(String propertyShapePrefixedNameOrIri, IRI propertyIri, Consumer<PropertyShape> propertyShapeConsumer) {
        this.property0((Resource)this.b.mapToIRI(propertyShapePrefixedNameOrIri), propertyIri);
        return this;
    }

    protected NodeShape property(String propertyShapePrefixedNameOrIri, RdfProperty property) {
        return this.property(this.b.mapToIRI(propertyShapePrefixedNameOrIri), (IRI)property.resource);
    }

    protected NodeShape property(String propertyShapePrefixedNameOrIri, String propertyPrefixedNameOrIri) {
        return this.property(this.b.mapToIRI(propertyShapePrefixedNameOrIri), this.b.mapToIRI(propertyPrefixedNameOrIri));
    }

    protected NodeShape property(String propertyShapePrefixedNameOrIri, IRI propertyIri) {
        this.property0((Resource)this.b.mapToIRI(propertyShapePrefixedNameOrIri), propertyIri);
        return this;
    }

    protected NodeShape property(IRI propertyShapeIri, RdfProperty property, Consumer<PropertyShape> propertyShapeConsumer) {
        return this.property(propertyShapeIri, (IRI)property.resource, propertyShapeConsumer);
    }

    protected NodeShape property(IRI propertyShapeIri, String propertyPrefixedNameOrIri, Consumer<PropertyShape> propertyShapeConsumer) {
        return this.property(propertyShapeIri, this.b.mapToIRI(propertyPrefixedNameOrIri), propertyShapeConsumer);
    }

    protected NodeShape property(IRI propertyShapeIri, IRI propertyIri, Consumer<PropertyShape> propertyShapeConsumer) {
        this.property0((Resource)propertyShapeIri, propertyIri);
        return this;
    }

    protected NodeShape property(IRI propertyShapeIri, RdfProperty property) {
        return this.property(propertyShapeIri, (IRI)property.resource);
    }

    protected NodeShape property(IRI propertyShapeIri, String propertyPrefixedNameOrIri) {
        return this.property(propertyShapeIri, this.b.mapToIRI(propertyPrefixedNameOrIri));
    }

    protected NodeShape property(IRI propertyShapeIri, IRI propertyIri) {
        this.property0((Resource)propertyShapeIri, propertyIri);
        return this;
    }

    protected PropertyShape property0(IRI propertyIri) {
        BNode propertyShapeBNode = this.b.valueFactory.createBNode();
        return this.property0((Resource)propertyShapeBNode, propertyIri);
    }

    protected PropertyShape property0(Resource propertyShapeResource, IRI propertyIri) {
        this.b.modelBuilder.subject(this.resource).add(SHACL.PROPERTY, (Object)propertyShapeResource);
        this.b.modelBuilder.subject(propertyShapeResource).add(SHACL.PATH, (Object)propertyIri);
        return new PropertyShape(this.b, propertyShapeResource);
    }

    public NodeShape deactivated(boolean yesOrNo) {
        this.b.modelBuilder.subject(this.resource).add(SHACL.DEACTIVATED, (Object)yesOrNo);
        return this;
    }

    public NodeShape closed(boolean yesOrNo) {
        this.b.modelBuilder.subject(this.resource).add(SHACL.CLOSED, (Object)yesOrNo);
        return this;
    }

    public NodeShape ignoredProperties(RdfProperty property, RdfProperty ... moreProperties) {
        RdfProperty[] in = new RdfProperty[moreProperties.length + 1];
        in[0] = property;
        System.arraycopy(moreProperties, 0, in, 1, moreProperties.length);
        List<IRI> ignoredProperties = Arrays.asList(in).stream().map(StructuralElement::getResource).collect(Collectors.toList());
        return this.ignoredProperties(ignoredProperties);
    }

    public NodeShape ignoredProperties(String propertyPrefixedNameOrIri, String ... morePropertyPrefixedNamesOrIris) {
        String[] in = new String[morePropertyPrefixedNamesOrIris.length + 1];
        in[0] = propertyPrefixedNameOrIri;
        System.arraycopy(morePropertyPrefixedNamesOrIris, 0, in, 1, morePropertyPrefixedNamesOrIris.length);
        List<IRI> ignoredProperties = Arrays.asList(in).stream().map(this.b::mapToIRI).collect(Collectors.toList());
        return this.ignoredProperties(ignoredProperties);
    }

    public NodeShape ignoredProperties(IRI propertyIri, IRI ... morePropertyIris) {
        IRI[] in = new IRI[morePropertyIris.length + 1];
        in[0] = propertyIri;
        System.arraycopy(morePropertyIris, 0, in, 1, morePropertyIris.length);
        return this.ignoredProperties(Arrays.asList(in));
    }

    public NodeShape ignoredProperties(Iterable<IRI> propertyIris) {
        BNode listHead = this.b.valueFactory.createBNode();
        RDFCollections.asRDF(propertyIris, (Resource)listHead, (Collection)this.b.model, (Resource[])new Resource[0]);
        this.b.modelBuilder.subject(this.resource).add(SHACL.IGNORED_PROPERTIES, (Object)listHead);
        return this;
    }

    public NodeShape any(BiConsumer<ModelBuilder, Resource> consumer) {
        super.any(consumer);
        return this;
    }
}

