/*
 * Decompiled with CFR 0.152.
 */
package ch.miranet.rdfstructure;

import ch.miranet.rdfstructure.ConceptScheme;
import ch.miranet.rdfstructure.NodeShape;
import ch.miranet.rdfstructure.OwlOntology;
import ch.miranet.rdfstructure.RdfProperty;
import ch.miranet.rdfstructure.RdfsClass;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.ModelBuilder;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.vocabulary.OWL;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.model.vocabulary.SKOS;

public class RdfStructureBuilder {
    protected final Model model;
    protected final ModelBuilder modelBuilder;
    protected final ValueFactory valueFactory;

    public RdfStructureBuilder() {
        this(RDF.NS, RDFS.NS, SHACL.NS, OWL.NS, SKOS.NS);
    }

    public RdfStructureBuilder(Namespace ... namespaces) {
        this((Model)null, namespaces);
    }

    protected RdfStructureBuilder(Model model, Namespace ... namespaces) {
        this.model = model == null ? new LinkedHashModel() : model;
        this.modelBuilder = new ModelBuilder(this.model);
        this.valueFactory = SimpleValueFactory.getInstance();
        for (Namespace ns : namespaces) {
            this.model.setNamespace(ns);
        }
    }

    public ModelBuilder getModelBuilder() {
        return this.modelBuilder;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public RdfsClass rdfsClass(String prefixedNameOrIri) {
        return this.rdfsClass(this.mapToIRI(prefixedNameOrIri));
    }

    public RdfsClass rdfsClass(IRI iri) {
        this.modelBuilder.subject((Resource)iri).add(RDF.TYPE, (Object)RDFS.CLASS);
        return new RdfsClass(this, iri);
    }

    public RdfProperty rdfProperty(String prefixedNameOrIri) {
        return this.rdfProperty(this.mapToIRI(prefixedNameOrIri));
    }

    public RdfProperty rdfProperty(IRI iri) {
        this.modelBuilder.subject((Resource)iri).add(RDF.TYPE, (Object)RDF.PROPERTY);
        return new RdfProperty(this, iri);
    }

    public NodeShape nodeShape() {
        BNode nodeShapeBNode = this.valueFactory.createBNode();
        return this.nodeShape0((Resource)nodeShapeBNode);
    }

    public NodeShape nodeShape(String prefixedNameOrIri) {
        return this.nodeShape(this.mapToIRI(prefixedNameOrIri));
    }

    public NodeShape nodeShape(IRI iri) {
        return this.nodeShape0((Resource)iri);
    }

    protected NodeShape nodeShape0(Resource nodeShapeResource) {
        this.modelBuilder.subject(nodeShapeResource).add(RDF.TYPE, (Object)SHACL.NODE_SHAPE);
        return new NodeShape(this, nodeShapeResource);
    }

    public OwlOntology owlOntology(String prefixedNameOrIri) {
        return this.owlOntology(this.mapToIRI(prefixedNameOrIri));
    }

    public OwlOntology owlOntology(IRI iri) {
        this.modelBuilder.subject((Resource)iri).add(RDF.TYPE, (Object)OWL.ONTOLOGY);
        return new OwlOntology(this, iri);
    }

    public ConceptScheme conceptScheme(String prefixedNameOrIri) {
        return this.conceptScheme(this.mapToIRI(prefixedNameOrIri));
    }

    public ConceptScheme conceptScheme(IRI iri) {
        this.modelBuilder.subject((Resource)iri).add(RDF.TYPE, (Object)SKOS.CONCEPT_SCHEME);
        return new ConceptScheme(this, iri);
    }

    protected IRI convertPrefixedName(String prefixedName) {
        if (prefixedName.indexOf(58) < 0) {
            return null;
        }
        String prefix = prefixedName.substring(0, prefixedName.indexOf(58));
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        for (Namespace ns : this.model.getNamespaces()) {
            if (!prefix.equals(ns.getPrefix())) continue;
            return vf.createIRI(ns.getName(), prefixedName.substring(prefixedName.indexOf(58) + 1));
        }
        return null;
    }

    protected IRI mapToIRI(String prefixedNameOrIRI) {
        if (prefixedNameOrIRI.indexOf(58) < 0) {
            throw new ModelException("not a valid prefixed name or IRI: " + prefixedNameOrIRI);
        }
        IRI iri = this.convertPrefixedName(prefixedNameOrIRI);
        if (iri == null) {
            iri = SimpleValueFactory.getInstance().createIRI(prefixedNameOrIRI);
        }
        return iri;
    }
}

