/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.metric;

import ch.mobi.mobitor.plugins.api.service.CollectorMetricService;
import com.google.common.collect.ImmutableList;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultCollectorMetricService
implements CollectorMetricService {
    private final MeterRegistry meterRegistry;
    private Map<String, AtomicLong> gaugeReferences = new HashMap<String, AtomicLong>();
    private Map<String, Date> collectorLastRun = new HashMap<String, Date>();

    @Autowired
    public DefaultCollectorMetricService(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public void submitCollectorDuration(@NotNull String collectorName, long durationInMs) {
        if (this.gaugeReferences.containsKey(collectorName)) {
            AtomicLong metricValue = this.gaugeReferences.get(collectorName);
            metricValue.set(durationInMs);
        } else {
            Tag collectorTag = Tag.of((String)"collector", (String)collectorName);
            ImmutableList tags = ImmutableList.of((Object)collectorTag);
            AtomicLong metricValue = new AtomicLong(durationInMs);
            AtomicLong gaugedLong = (AtomicLong)this.meterRegistry.gauge("gauge_collector_duration_ms", (Iterable)tags, (Number)metricValue);
            this.gaugeReferences.put(collectorName, gaugedLong);
        }
    }

    public void updateLastRunCompleted(String infoType) {
        this.collectorLastRun.put(infoType, new Date());
    }

    public Map<String, Date> getCollectorLastRun() {
        return this.collectorLastRun;
    }
}

