/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor;

import ch.mobi.mobitor.domain.factory.ExtendableScreenFactory;
import ch.mobi.mobitor.domain.screen.DefaultScreen;
import ch.mobi.mobitor.domain.screen.Screen;
import ch.mobi.mobitor.plugins.api.domain.config.ExtendableScreenConfig;
import ch.mobi.mobitor.plugins.api.model.ScreensModel;
import ch.mobi.mobitor.service.config.ExtendableScreenConfigService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class SetupScreenConfigApplicationListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(SetupScreenConfigApplicationListener.class);
    private final ScreensModel screensModel;
    private final ExtendableScreenConfigService extendableScreenConfigService;
    private final ExtendableScreenFactory extendableScreenFactory;

    @Autowired
    public SetupScreenConfigApplicationListener(ScreensModel screensModel, ExtendableScreenConfigService extendableScreenConfigService, ExtendableScreenFactory extendableScreenFactory) {
        this.screensModel = screensModel;
        this.extendableScreenConfigService = extendableScreenConfigService;
        this.extendableScreenFactory = extendableScreenFactory;
    }

    private void addEmptyScreen(ExtendableScreenConfig screenConfig) {
        DefaultScreen screen = this.extendableScreenFactory.initializeEmptyScreen(screenConfig);
        this.screensModel.addScreen((Screen)screen);
        LOG.debug("added extendable screen to model: " + screen.getConfigKey());
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        LOG.info("application started, initialize screen configurations...");
        List<ExtendableScreenConfig> extendableScreenConfigs = this.extendableScreenConfigService.getConfigs();
        extendableScreenConfigs.forEach(this::addEmptyScreen);
        LOG.info("Empty screens have been initialized.");
    }
}

