/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.domain.screen;

import ch.mobi.mobitor.domain.screen.RuleEvaluation;
import ch.mobi.mobitor.domain.screen.RuleMessage;
import ch.mobi.mobitor.domain.screen.RuleViolationSeverity;
import ch.mobi.mobitor.plugins.api.domain.screen.information.ApplicationInformation;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Set;

public class DefaultRuleEvaluation
implements RuleEvaluation {
    private ListMultimap<String, ApplicationInformation> violationsMap = ArrayListMultimap.create();
    private ListMultimap<String, RuleMessage> messageMap = ArrayListMultimap.create();

    public void addViolation(String env, ApplicationInformation applicationInformation, RuleViolationSeverity severity, String message) {
        this.violationsMap.put((Object)env, (Object)applicationInformation);
        this.messageMap.put((Object)env, (Object)new RuleMessage(severity, message));
    }

    public boolean hasErrors() {
        return this.hasMessageWithSeverity(RuleViolationSeverity.ERROR);
    }

    public boolean hasWarnings() {
        return this.hasMessageWithSeverity(RuleViolationSeverity.WARNING);
    }

    public boolean hasViolationsOrWarnings() {
        return this.hasErrors() || this.hasWarnings();
    }

    private boolean hasMessageWithSeverity(RuleViolationSeverity severity) {
        for (RuleMessage ruleMessage : this.messageMap.values()) {
            if (!severity.equals((Object)ruleMessage.getSeverity())) continue;
            return true;
        }
        return false;
    }

    public Set<String> getAffectedEnvironments() {
        return this.violationsMap.keySet();
    }

    public List<RuleMessage> getMessages(String environment) {
        return this.messageMap.get((Object)environment);
    }
}

