/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.domain.screen;

import ch.mobi.mobitor.domain.screen.ServerContext;
import ch.mobi.mobitor.plugins.api.domain.screen.information.ApplicationInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultServerContext
implements ServerContext {
    private Map<String, List<ApplicationInformation>> applicationInformationMap = new HashMap<String, List<ApplicationInformation>>();

    public void addInformation(String applicationName, ApplicationInformation information) {
        List<ApplicationInformation> applicationInformationList = this.applicationInformationMap.get(applicationName);
        if (applicationInformationList == null) {
            applicationInformationList = new ArrayList<ApplicationInformation>();
            this.applicationInformationMap.put(applicationName, applicationInformationList);
        }
        applicationInformationList.add(information);
    }

    public List<ApplicationInformation> getMatchingInformation(String type, String applicationName) {
        List<ApplicationInformation> applicationInformationList = this.applicationInformationMap.get(applicationName);
        return applicationInformationList == null ? new ArrayList<ApplicationInformation>() : applicationInformationList.stream().filter(info -> info.getType().equals(type)).collect(Collectors.toList());
    }

    public List<ApplicationInformation> getMatchingInformationByApplicationName(String applicationName) {
        ArrayList matchingAppInfos = this.applicationInformationMap.get(applicationName);
        return Collections.unmodifiableList(matchingAppInfos == null ? new ArrayList() : matchingAppInfos);
    }

    public <T extends ApplicationInformation> List<T> getMatchingInformation(String type) {
        ArrayList<ApplicationInformation> allMatchingInfos = new ArrayList<ApplicationInformation>();
        for (Map.Entry<String, List<ApplicationInformation>> entry : this.applicationInformationMap.entrySet()) {
            List<ApplicationInformation> matchingInformation = this.getMatchingInformation(type, entry.getKey());
            allMatchingInfos.addAll(matchingInformation);
        }
        return allMatchingInfos;
    }
}

