/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.service.scheduling;

import ch.mobi.mobitor.ChangelogConfiguration;
import ch.mobi.mobitor.domain.config.ChangelogConfig;
import ch.mobi.mobitor.domain.deployment.Deployment;
import ch.mobi.mobitor.plugin.bitbucket.service.client.BitBucketClient;
import ch.mobi.mobitor.plugin.bitbucket.service.client.domain.BitBucketCommitInfoResponse;
import ch.mobi.mobitor.plugin.jira.service.client.JiraClient;
import ch.mobi.mobitor.plugin.jira.service.client.domain.IssueResponse;
import ch.mobi.mobitor.service.DeploymentInformationService;
import ch.mobi.mobitor.service.EnvironmentsConfigurationService;
import ch.mobi.mobitor.service.config.ChangelogConfigurationService;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.format.DateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"mobitor.modules.changelog.enabled"}, havingValue="true")
public class ChangelogInformationCollector {
    private static final Logger LOG = LoggerFactory.getLogger(ChangelogInformationCollector.class);
    private final BitBucketClient bitBucketClient;
    private final JiraClient jiraClient;
    private final DeploymentInformationService deploymentInformationService;
    private final ChangelogConfigurationService changelogConfigurationService;
    private final EnvironmentsConfigurationService environmentsConfigurationService;
    private final ChangelogConfiguration changelogConfiguration;

    @Autowired
    public ChangelogInformationCollector(BitBucketClient bitBucketClient, JiraClient jiraClient, DeploymentInformationService deploymentInformationService, ChangelogConfigurationService changelogConfigurationService, EnvironmentsConfigurationService environmentsConfigurationService, ChangelogConfiguration changelogConfiguration) {
        this.bitBucketClient = bitBucketClient;
        this.jiraClient = jiraClient;
        this.deploymentInformationService = deploymentInformationService;
        this.changelogConfigurationService = changelogConfigurationService;
        this.environmentsConfigurationService = environmentsConfigurationService;
        this.changelogConfiguration = changelogConfiguration;
    }

    @Scheduled(cron="0 0 5,12 * * ?")
    @CacheEvict(cacheNames={"cache_changelogIssues"}, allEntries=true)
    public void collectChangelogInformation() {
        long start = System.currentTimeMillis();
        this.changelogConfigurationService.getAllChangelogConfigs().forEach(this::loadAndForwardChangelogInformation);
        long stop = System.currentTimeMillis();
        LOG.info("reading changelog information took: " + (stop - start) + "ms");
        this.changelogConfigurationService.setChangelogRefresh(new Date());
    }

    private void loadAndForwardChangelogInformation(ChangelogConfig changelogConfig) {
        String serverName = changelogConfig.getServerName();
        List<String> envs = changelogConfig.getEnvironments();
        envs.forEach(env -> {
            Deployment deployment = this.loadSuccessfulDeployment(serverName, (String)env);
            if (deployment != null) {
                String version = deployment.getFirstApplicationVersion();
                if (StringUtils.isNotBlank((CharSequence)changelogConfig.getParameterName())) {
                    version = deployment.getParameter(changelogConfig.getParameterName());
                }
                String project = changelogConfig.getProject();
                String repository = changelogConfig.getRepository();
                String until = "release/" + StringUtils.trimToEmpty((String)version);
                List commits = this.bitBucketClient.retrieveCommits(project, repository, until);
                Set<String> jiraIssues = this.filterIssuesInCommitsByEndingTransition(commits);
                long deploymentTimestamp = deployment.getDeploymentDate();
                for (String jiraIssueKey : jiraIssues) {
                    if (!this.issueIsNotInBlacklistedProject(jiraIssueKey)) continue;
                    IssueResponse issueResponse = this.jiraClient.retrieveIssue(jiraIssueKey);
                    if (issueResponse != null) {
                        Set deploymentEnvironments = issueResponse.getFields().getDeploymentEnvironments(this.changelogConfiguration.getCustomFieldNameDeploymentEnvironments());
                        String jiraEnvName = this.environmentsConfigurationService.getName(env);
                        HashSet<String> envsForJira = new HashSet<String>(deploymentEnvironments);
                        envsForJira.add(jiraEnvName);
                        if (SetUtils.isEqualSet((Collection)deploymentEnvironments, envsForJira)) {
                            LOG.debug("Issue does not require updating, no changes: " + jiraIssueKey);
                        } else {
                            this.jiraClient.updateCustomField(jiraIssueKey, this.changelogConfiguration.getCustomFieldNameDeploymentEnvironments(), envsForJira);
                            LOG.info("Updated Jira issue: " + jiraIssueKey);
                        }
                        if ("preprod-t".equals(jiraEnvName)) {
                            this.updateDeploymentDate(jiraIssueKey, issueResponse, this.changelogConfiguration.getCustomFieldNameDeploymentDatePreProd(), deploymentTimestamp);
                        }
                        if (!"produktion-p".equals(jiraEnvName)) continue;
                        this.updateDeploymentDate(jiraIssueKey, issueResponse, this.changelogConfiguration.getCustomFieldNameDeploymentDateProduction(), deploymentTimestamp);
                        continue;
                    }
                    LOG.warn("Commit message contains non-existing issue: " + jiraIssueKey);
                }
            }
        });
    }

    public boolean issueIsNotInBlacklistedProject(String jiraIssueKey) {
        for (String blacklistedProjectPrefix : this.changelogConfiguration.getBlacklistedProjects()) {
            if (!jiraIssueKey.startsWith(blacklistedProjectPrefix)) continue;
            return false;
        }
        return true;
    }

    private void updateDeploymentDate(String jiraIssueKey, IssueResponse issueResponse, String customFieldName, long deploymentTimestamp) {
        Date deploymentDate = issueResponse.getFields().getDeploymentDate(customFieldName);
        if (deploymentDate == null) {
            String currentDateForJira = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZ").print(deploymentTimestamp);
            this.jiraClient.updateCustomField(jiraIssueKey, customFieldName, (Object)currentDateForJira);
        }
    }

    private Set<String> filterIssuesInCommitsByEndingTransition(List<BitBucketCommitInfoResponse> commits) {
        Set<String> jiraIssueSet = commits.stream().map(BitBucketCommitInfoResponse::getJiraKeys).flatMap(Collection::stream).collect(Collectors.toSet());
        LOG.debug("Found Jira Issues: " + Objects.toString(jiraIssueSet));
        return jiraIssueSet;
    }

    private Deployment loadSuccessfulDeployment(String serverName, String environment) {
        try {
            List deployments = this.deploymentInformationService.retrieveDeployments(serverName);
            List filteredDeployments = this.deploymentInformationService.filterDeployments(deployments, (Set)Sets.newHashSet((Object[])new String[]{environment}));
            if (filteredDeployments != null && filteredDeployments.size() == 1) {
                Deployment deployment = (Deployment)filteredDeployments.get(0);
                return deployment.isSuccessful() ? deployment : null;
            }
        }
        catch (Exception e) {
            LOG.error("Could not load deployment from LIIMA.");
        }
        return null;
    }
}

