/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.service.rules;

import ch.mobi.mobitor.domain.screen.DefaultRuleEvaluation;
import ch.mobi.mobitor.domain.screen.Pipeline;
import ch.mobi.mobitor.domain.screen.PipelineRule;
import ch.mobi.mobitor.domain.screen.RuleEvaluation;
import ch.mobi.mobitor.domain.screen.RuleEvaluationSeverity;
import ch.mobi.mobitor.domain.screen.Screen;
import ch.mobi.mobitor.plugins.api.service.RuleService;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultRuleService
implements RuleService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRuleService.class);
    private List<PipelineRule> pipelineRules;

    @Autowired
    public DefaultRuleService(List<PipelineRule> pipelineRules) {
        this.pipelineRules = pipelineRules;
        LOG.info("Number of rules found: " + pipelineRules.size());
        for (PipelineRule pipelineRule : pipelineRules) {
            LOG.info("Will evaluate rule: " + pipelineRule.getClass().getName());
        }
    }

    public void updateRuleEvaluation(Screen screen, String type) {
        screen.getPipelines().forEach(pipeline -> this.updateRuleEvaluation((Pipeline)pipeline, type));
    }

    private void updateRuleEvaluation(Pipeline pipeline, String type) {
        pipeline.resetRuleEvaluation(type);
        this.pipelineRules.stream().filter(pipelineRule -> pipelineRule.validatesType(type)).forEach(pipelineRule -> {
            DefaultRuleEvaluation ruleEvaluation = new DefaultRuleEvaluation();
            pipelineRule.evaluateRule(pipeline, (RuleEvaluation)ruleEvaluation);
            if (ruleEvaluation.hasErrors() || ruleEvaluation.hasWarnings()) {
                pipeline.updateRuleEvaluation(type, (RuleEvaluation)ruleEvaluation);
            }
        });
        if (pipeline.getRuleEvaluationSeverity() == RuleEvaluationSeverity.TROPHY || pipeline.getRuleEvaluationSeverity() == RuleEvaluationSeverity.WARNINGS_ONLY) {
            pipeline.setLastRuleCompliantDate(new Date());
        }
    }
}

