/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor;

import ch.mobi.mobitor.domain.screen.DefaultPipeline;
import ch.mobi.mobitor.domain.screen.DefaultScreen;
import ch.mobi.mobitor.domain.screen.DefaultServerContext;
import ch.mobi.mobitor.model.ScreenViewHelper;
import ch.mobi.mobitor.plugins.api.MobitorPlugin;
import ch.mobi.mobitor.service.plugins.MobitorPluginsRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class LegendController {
    private final MobitorPluginsRegistry pluginsRegistry;
    private final ScreenViewHelper screenViewHelper;

    @Autowired
    public LegendController(MobitorPluginsRegistry pluginsRegistry, ScreenViewHelper screenViewHelper) {
        this.pluginsRegistry = pluginsRegistry;
        this.screenViewHelper = screenViewHelper;
    }

    @RequestMapping(value={"/legend"})
    public String overview(Model model) {
        List<MobitorPlugin> plugins = this.pluginsRegistry.getConfigPlugins();
        HashMap<String, List> legend = new HashMap<String, List>();
        for (MobitorPlugin plugin : plugins) {
            String pluginConfigPropName = plugin.getConfigPropertyName();
            List informationList = plugin.getLegendApplicationInformationList();
            legend.put(pluginConfigPropName, informationList);
        }
        model.addAttribute("legend", legend);
        model.addAttribute("svh", (Object)this.screenViewHelper);
        DefaultScreen legendScreen = new DefaultScreen.Builder().configKey("LEGEND").label("Legend Screen").environments(Arrays.asList("build", "test", "prod")).serverNames(Arrays.asList("legendServer1", "legendServer2")).refreshInterval(-1).build();
        model.addAttribute("screen", (Object)legendScreen);
        Map<String, DefaultServerContext> serverContextMap = Map.of("build", new DefaultServerContext());
        DefaultPipeline legendPipeline = new DefaultPipeline("legendServer", serverContextMap);
        model.addAttribute("pipeline", (Object)legendPipeline);
        model.addAttribute("applicationName", (Object)"legendApplication1");
        return "legend";
    }
}

