/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.domain.screen;

import ch.mobi.mobitor.domain.screen.DefaultPipeline;
import ch.mobi.mobitor.domain.screen.DefaultServerContext;
import ch.mobi.mobitor.domain.screen.Pipeline;
import ch.mobi.mobitor.domain.screen.Screen;
import ch.mobi.mobitor.plugins.api.domain.config.OnDutyConfig;
import ch.mobi.mobitor.plugins.api.domain.screen.information.ApplicationInformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

public class DefaultScreen
implements Screen {
    @NotNull
    private String configKey;
    @NotNull
    private String label;
    private OnDutyConfig onDuty;
    @NotNull
    private int refreshInterval;
    @NotEmpty
    private List<String> environments = new ArrayList<String>();
    @NotEmpty
    private List<Pipeline> pipelines = new ArrayList<Pipeline>();
    @NotNull
    private Map<String, Date> refreshDates = new HashMap<String, Date>();

    private DefaultScreen(String configKey, String label, int refreshInterval, List<String> environments, List<String> serverNames) {
        this.configKey = configKey;
        this.label = label;
        this.refreshInterval = refreshInterval;
        this.environments = environments;
        this.initializePipelines(serverNames, environments);
    }

    private Map<String, DefaultServerContext> createServerContextMap() {
        HashMap<String, DefaultServerContext> serverContextMap = new HashMap<String, DefaultServerContext>();
        for (String env : this.environments) {
            serverContextMap.put(env, new DefaultServerContext());
        }
        return serverContextMap;
    }

    private void initializePipelines(List<String> serverNames, List<String> environments) {
        for (String serverName : serverNames) {
            DefaultPipeline pipeline = new DefaultPipeline(serverName, this.createServerContextMap());
            this.addPipeline(pipeline);
        }
    }

    public void addInformation(String serverName, String applicationName, String environment, ApplicationInformation information) {
        Pipeline pipeline = this.getAndInitializePipeline(serverName);
        pipeline.addInformation(environment, applicationName, information);
    }

    private Pipeline getAndInitializePipeline(String serverName) {
        for (Pipeline pipeline : this.pipelines) {
            if (!serverName.equals(pipeline.getAppServerName())) continue;
            return pipeline;
        }
        DefaultPipeline pipeline = new DefaultPipeline(serverName, this.createServerContextMap());
        this.addPipeline(pipeline);
        return pipeline;
    }

    public OnDutyConfig getOnDuty() {
        return this.onDuty;
    }

    public void setOnDuty(OnDutyConfig onDuty) {
        this.onDuty = onDuty;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public String getLabel() {
        return this.label;
    }

    public int getRefreshInterval() {
        return this.refreshInterval;
    }

    public void addEnvironments(List<String> environments) {
        this.environments.addAll(environments);
    }

    public List<Pipeline> getPipelines() {
        List<Pipeline> pipelines = Collections.unmodifiableList(this.pipelines);
        return pipelines;
    }

    public List<String> getEnvironments() {
        return this.environments;
    }

    public <T extends ApplicationInformation> List<T> getMatchingInformation(String type, String environment, String serverName, String applicationName) {
        for (Pipeline pipeline : this.pipelines) {
            if (!serverName.equals(pipeline.getAppServerName())) continue;
            return pipeline.getMatchingInformation(type, environment, applicationName);
        }
        return new ArrayList();
    }

    public <T extends ApplicationInformation> List<T> getMatchingInformation(String type) {
        ArrayList allInformationByTypeList = new ArrayList();
        this.pipelines.forEach(pipeline -> pipeline.getServerContextMap().values().forEach(srvCtx -> allInformationByTypeList.addAll(srvCtx.getMatchingInformation(type))));
        return allInformationByTypeList;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public void addPipeline(DefaultPipeline pipeline) {
        this.pipelines.add(pipeline);
    }

    public void setRefreshDate(String type, Date refreshDate) {
        this.refreshDates.put(type, refreshDate);
    }

    public Date getRefreshDate(String type) {
        return this.refreshDates.get(type);
    }

    public Map<String, Date> getRefreshDates() {
        return this.refreshDates;
    }

    public static class Builder {
        private String configKey;
        private String label;
        private List<String> environments;
        private List<String> serverNames;
        private int refreshInterval;

        public DefaultScreen build() {
            DefaultScreen screen = new DefaultScreen(this.configKey, this.label, this.refreshInterval, this.environments, this.serverNames);
            return screen;
        }

        public Builder configKey(String configKey) {
            this.configKey = configKey;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder refreshInterval(int refreshInterval) {
            this.refreshInterval = refreshInterval;
            return this;
        }

        public Builder environments(List<String> environments) {
            this.environments = environments;
            return this;
        }

        public Builder serverNames(List<String> serverNames) {
            this.serverNames = serverNames;
            return this;
        }
    }
}

