/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.service.plugins;

import ch.mobi.mobitor.plugins.api.MobitorPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MobitorPluginsRegistry {
    private List<MobitorPlugin> configPlugins = new ArrayList<MobitorPlugin>();
    private Map<String, MobitorPlugin> confPluginsMap = new HashMap<String, MobitorPlugin>();

    @Autowired
    public MobitorPluginsRegistry(Optional<List<MobitorPlugin>> optConfigPlugins) {
        optConfigPlugins.ifPresent(plugins -> {
            this.configPlugins = plugins;
        });
    }

    @PostConstruct
    public void initialize() {
        this.configPlugins.forEach(p -> this.confPluginsMap.put(p.getConfigPropertyName(), (MobitorPlugin)p));
    }

    public List<MobitorPlugin> getConfigPlugins() {
        return this.configPlugins;
    }

    public MobitorPlugin getPlugin(String configPropertyName) {
        return this.confPluginsMap.get(configPropertyName);
    }
}

