/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor;

import ch.mobi.mobitor.domain.screen.Screen;
import ch.mobi.mobitor.model.EnvironmentInformationHelper;
import ch.mobi.mobitor.model.ScreenViewHelper;
import ch.mobi.mobitor.plugins.api.domain.screen.information.ScreenAttributeProvider;
import ch.mobi.mobitor.plugins.api.model.ScreensModel;
import ch.mobi.mobitor.service.OnDutyService;
import ch.mobi.mobitor.service.plugins.MobitorPluginsRegistry;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ScreenController {
    private final ScreensModel screensModel;
    private final ScreenViewHelper screenViewHelper;
    private final OnDutyService onDutyService;
    private final EnvironmentInformationHelper environmentInformationHelper;
    private final MobitorPluginsRegistry pluginsRegistry;

    @Autowired
    public ScreenController(ScreensModel screensModel, ScreenViewHelper screenViewHelper, OnDutyService onDutyService, EnvironmentInformationHelper environmentInformationHelper, MobitorPluginsRegistry pluginsRegistry) {
        this.screensModel = screensModel;
        this.screenViewHelper = screenViewHelper;
        this.onDutyService = onDutyService;
        this.environmentInformationHelper = environmentInformationHelper;
        this.pluginsRegistry = pluginsRegistry;
    }

    @RequestMapping(value={"/screen"})
    public String overview(@RequestParam(value="key", required=false, defaultValue="1") String screenConfigKey, @RequestParam(value="rotate", required=false, defaultValue="") String rotate, Model model) {
        String nextScreenConfigKey = screenConfigKey;
        if (StringUtils.isNotBlank((CharSequence)rotate)) {
            String[] screenKeysToRotate = rotate.split(",");
            for (int i = 0; i < screenKeysToRotate.length; ++i) {
                String screenKey = screenKeysToRotate[i];
                if (!screenKey.equals(screenConfigKey)) continue;
                int pos = (i + 1) % screenKeysToRotate.length;
                nextScreenConfigKey = screenKeysToRotate[pos];
                break;
            }
        }
        model.addAttribute("screenConfigKey", (Object)screenConfigKey);
        model.addAttribute("nextScreenConfigKey", (Object)nextScreenConfigKey);
        model.addAttribute("rotate", (Object)rotate);
        this.pluginsRegistry.getConfigPlugins().forEach(plugin -> {
            ScreenAttributeProvider screenAttributeProvider = plugin.getScreenAttributeProvider();
            Map attributes = screenAttributeProvider.getAttributes();
            model.addAllAttributes(attributes);
        });
        if (this.screensModel.hasScreen(screenConfigKey)) {
            Screen screen = this.screensModel.getScreen(screenConfigKey);
            if (screen == null) {
                return "nodata";
            }
            model.addAttribute("screen", (Object)screen);
            model.addAttribute("svh", (Object)this.screenViewHelper);
            model.addAttribute("eih", (Object)this.environmentInformationHelper);
            model.addAttribute("onDutyService", (Object)this.onDutyService);
            return "screen";
        }
        return "invalidscreenconfig";
    }
}

