/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.domain.factory;

import ch.mobi.mobitor.domain.screen.DefaultScreen;
import ch.mobi.mobitor.domain.screen.Screen;
import ch.mobi.mobitor.plugins.api.MobitorPlugin;
import ch.mobi.mobitor.plugins.api.domain.config.ExtendableScreenConfig;
import ch.mobi.mobitor.service.plugins.MobitorPluginsRegistry;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExtendableScreenFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ExtendableScreenFactory.class);
    private final MobitorPluginsRegistry pluginsRegistry;

    @Autowired
    public ExtendableScreenFactory(MobitorPluginsRegistry pluginsRegistry) {
        this.pluginsRegistry = pluginsRegistry;
    }

    public DefaultScreen initializeEmptyScreen(ExtendableScreenConfig screenConfig) {
        DefaultScreen screen = new DefaultScreen.Builder().configKey(screenConfig.getConfigKey()).label(screenConfig.getLabel()).environments(screenConfig.getEnvironments()).serverNames(screenConfig.getServerNames()).build();
        screen.setOnDuty(screenConfig.getOnDuty());
        Map pluginConfigMap = screenConfig.getPluginConfigMap();
        for (Map.Entry pluginConfigEntry : pluginConfigMap.entrySet()) {
            MobitorPlugin plugin = this.pluginsRegistry.getPlugin((String)pluginConfigEntry.getKey());
            if (plugin == null) continue;
            List configs = (List)screenConfig.getPluginConfigMap().get(plugin.getConfigPropertyName());
            plugin.createAndAssociateApplicationInformationBlocks((Screen)screen, screenConfig, configs);
        }
        LOG.debug("Screen creation based on plugins complete.");
        return screen;
    }
}

