/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.service.config;

import ch.mobi.mobitor.domain.config.ChangelogConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;

@Service
public class ChangelogConfigurationService {
    private static final Logger LOG = LoggerFactory.getLogger(ChangelogConfigurationService.class);
    private final ResourceLoader resourceLoader;
    private List<ChangelogConfig> changelogConfigs;
    private Date changelogRefresh;

    @Autowired
    public ChangelogConfigurationService(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @PostConstruct
    public void initializeChangelogRepositories() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        Resource resource = this.resourceLoader.getResource("classpath:screen/changelog-repositories.json");
        try (InputStream inputStream = resource.getInputStream();){
            this.changelogConfigs = (List)mapper.readValue(inputStream, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, ChangelogConfig.class));
        }
        catch (Exception e) {
            LOG.error("Could not initialize changelog configuration / repositories.", (Throwable)e);
        }
    }

    public List<ChangelogConfig> getAllChangelogConfigs() {
        return Collections.unmodifiableList(this.changelogConfigs);
    }

    public void setChangelogRefresh(Date changelogRefresh) {
        this.changelogRefresh = changelogRefresh;
    }

    public Date getChangelogRefresh() {
        return this.changelogRefresh;
    }
}

