/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.service;

import ch.mobi.mobitor.plugins.api.domain.config.OnDutyConfig;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Weeks;
import org.springframework.stereotype.Service;

@Service
public class OnDutyService {
    public String getCurrentOnDutyTeam(OnDutyConfig onDuty) {
        int weeks = this.getWeeksUntilNow(onDuty.getSprintStart());
        int sprintNumbers = weeks / onDuty.getSprintDuration();
        int teamOnDuty = sprintNumbers % onDuty.getTeams().size();
        return (String)onDuty.getTeams().get(teamOnDuty);
    }

    public String getNextOnDutyTeam(OnDutyConfig onDuty) {
        int nextPosition = onDuty.getTeams().indexOf(this.getCurrentOnDutyTeam(onDuty)) + 1;
        if (nextPosition > onDuty.getTeams().size() - 1) {
            nextPosition = 0;
        }
        return (String)onDuty.getTeams().get(nextPosition);
    }

    public String getChangeDate(OnDutyConfig onDuty) {
        int weeks = this.getWeeksUntilNow(onDuty.getSprintStart());
        weeks = 0 == weeks % onDuty.getSprintDuration() ? onDuty.getSprintDuration() + weeks : weeks % onDuty.getSprintDuration() + weeks;
        DateTime changeDate = this.stringToDateTime(onDuty.getSprintStart()).minusDays(1).plusWeeks(weeks);
        return changeDate.toString("dd-MM-yyyy");
    }

    public int getWeeksUntilNow(String sprintStart) {
        return Weeks.weeksBetween((ReadableInstant)this.stringToDateTime(sprintStart), (ReadableInstant)this.getNow()).getWeeks();
    }

    public DateTime stringToDateTime(String time) {
        return new DateTime((Object)DateTime.parse((String)time));
    }

    public DateTime getNow() {
        return new DateTime();
    }
}

