/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor.domain.screen;

import ch.mobi.mobitor.domain.screen.DefaultServerContext;
import ch.mobi.mobitor.domain.screen.Pipeline;
import ch.mobi.mobitor.domain.screen.RuleEvaluation;
import ch.mobi.mobitor.domain.screen.RuleEvaluationSeverity;
import ch.mobi.mobitor.domain.screen.ServerContext;
import ch.mobi.mobitor.plugins.api.domain.screen.information.ApplicationInformation;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultPipeline
implements Pipeline {
    private String appServerName;
    private Date lastRuleCompliantDate;
    private Date lastRuleUpdateDate;
    private Map<String, DefaultServerContext> serverContextMap = new HashMap<String, DefaultServerContext>();
    private ListMultimap<String, RuleEvaluation> ruleEvaluationMap = ArrayListMultimap.create();
    private Set<String> applicationNames = new LinkedHashSet<String>();

    public DefaultPipeline(String appServerName, Map<String, DefaultServerContext> serverContextMap) {
        this.appServerName = appServerName;
        this.serverContextMap.putAll(serverContextMap);
    }

    public String getAppServerName() {
        return this.appServerName;
    }

    public void addInformation(String environment, String applicationName, ApplicationInformation information) {
        DefaultServerContext serverContext = this.serverContextMap.get(environment);
        if (serverContext == null) {
            throw new IllegalStateException("Environment [" + environment + "] for application [" + applicationName + "] is not declared in the environments list");
        }
        serverContext.addInformation(applicationName, information);
        this.applicationNames.add(applicationName);
    }

    public List<ApplicationInformation> getMatchingInformation(String type, String environment, String applicationName) {
        DefaultServerContext serverContext = this.serverContextMap.get(environment);
        List<ApplicationInformation> informationList = serverContext.getMatchingInformation(type, applicationName);
        return informationList;
    }

    public DefaultServerContext getServerContext(String environment) {
        return this.serverContextMap.get(environment);
    }

    public Map<String, ServerContext> getServerContextMap() {
        return Collections.unmodifiableMap(this.serverContextMap);
    }

    public void updateRuleEvaluation(String informationType, RuleEvaluation ruleEvaluation) {
        this.ruleEvaluationMap.put((Object)informationType, (Object)ruleEvaluation);
        this.lastRuleUpdateDate = new Date();
    }

    public void resetRuleEvaluation(String type) {
        this.ruleEvaluationMap.removeAll((Object)type);
        this.lastRuleUpdateDate = new Date();
    }

    public RuleEvaluationSeverity getRuleEvaluationSeverity() {
        if (!this.hasNoViolations()) {
            return RuleEvaluationSeverity.CONTAINS_ERRORS;
        }
        if (!this.hasNoWarnings()) {
            return RuleEvaluationSeverity.WARNINGS_ONLY;
        }
        return RuleEvaluationSeverity.TROPHY;
    }

    private boolean hasNoViolations() {
        for (RuleEvaluation ruleEvaluation : this.ruleEvaluationMap.values()) {
            if (!ruleEvaluation.hasErrors()) continue;
            return false;
        }
        return true;
    }

    private boolean hasNoWarnings() {
        for (RuleEvaluation ruleEvaluation : this.ruleEvaluationMap.values()) {
            if (!ruleEvaluation.hasWarnings()) continue;
            return false;
        }
        return true;
    }

    public List<String> getViolatedTypes() {
        return this.ruleEvaluationMap.asMap().entrySet().stream().filter(map -> ((Collection)map.getValue()).size() > 0).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public List<RuleEvaluation> getRuleEvaluations(String type) {
        return this.ruleEvaluationMap.get((Object)type);
    }

    public Date getLastRuleCompliantDate() {
        return this.lastRuleCompliantDate;
    }

    public void setLastRuleCompliantDate(Date date) {
        this.lastRuleCompliantDate = date;
    }

    public Date getLastRuleUpdateDate() {
        return this.lastRuleUpdateDate;
    }

    public Set<String> getApplicationNames() {
        return this.applicationNames;
    }
}

