/*
 * Decompiled with CFR 0.152.
 */
package ch.mobi.mobitor;

import ch.mobi.mobitor.domain.screen.Screen;
import ch.mobi.mobitor.domain.screen.ScreenLabelComparator;
import ch.mobi.mobitor.model.ScreenViewHelper;
import ch.mobi.mobitor.plugins.api.model.ScreensModel;
import ch.mobi.mobitor.service.config.MobitorApplicationConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class IndexController {
    private final ScreensModel screensModel;
    private final MobitorApplicationConfiguration mobitorConfiguration;
    private final ScreenViewHelper screenViewHelper;

    @Autowired
    public IndexController(ScreensModel screensModel, MobitorApplicationConfiguration mobitorConfiguration, ScreenViewHelper screenViewHelper) {
        this.screensModel = screensModel;
        this.mobitorConfiguration = mobitorConfiguration;
        this.screenViewHelper = screenViewHelper;
    }

    @RequestMapping(value={"/"})
    public String index(Model model) {
        List screens = this.screensModel.getAvailableScreens();
        ArrayList<Screen> sortedScreens = new ArrayList<Screen>(screens);
        sortedScreens.sort(new ScreenLabelComparator());
        model.addAttribute("screens", sortedScreens);
        model.addAttribute("applicationVersion", (Object)this.mobitorConfiguration.getVersion());
        model.addAttribute("activeProfiles", (Object)this.mobitorConfiguration.getActiveProfiles());
        model.addAttribute("network", (Object)this.mobitorConfiguration.getNetwork());
        model.addAttribute("svh", (Object)this.screenViewHelper);
        return "index";
    }
}

